/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport;

import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.ImportProgressCtrl;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ColumnMappingTableModel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.UnsupportedFormatException;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.util.DateUtils;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ImportDataIntoTableExecutor {
    private static final ILogger s_log = LoggerController.createLogger(ImportDataIntoTableExecutor.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportDataIntoTableExecutor.class);
    private ISession _session;
    private ITableInfo _table;
    private ExtendedColumnInfo[] _columns;
    private ColumnMappingTableModel _columnMappingModel;
    private IFileImporter _importer;
    private List<String> _importerColumns;
    private boolean skipHeader = false;
    private final boolean _singleTransaction;
    private final int _commitAfterEveryInserts;
    private boolean _deleteExistingData;

    public ImportDataIntoTableExecutor(ISession session, ITableInfo table, ExtendedColumnInfo[] columns, List<String> importerColumns, ColumnMappingTableModel mapping, IFileImporter importer, boolean singleTransaction, int commitAfterEveryInserts, boolean deleteExistingData) {
        this._session = session;
        this._table = table;
        this._columns = columns;
        this._columnMappingModel = mapping;
        this._importer = importer;
        this._importerColumns = importerColumns;
        this._singleTransaction = singleTransaction;
        this._commitAfterEveryInserts = commitAfterEveryInserts;
        this._deleteExistingData = deleteExistingData;
    }

    public void setSkipHeader(boolean skip) {
        this.skipHeader = skip;
    }

    public void execute() {
        ImportProgressCtrl importProgressCtrl = new ImportProgressCtrl(this._table);
        Thread execThread = new Thread(() -> this._execute(this._singleTransaction, this._commitAfterEveryInserts, this._deleteExistingData, importProgressCtrl));
        execThread.setName("Dataimport Executor Thread");
        execThread.setUncaughtExceptionHandler(this.createUncaughtExceptionHandler());
        execThread.start();
    }

    /*
     * Exception decompiling
     */
    private void _execute(boolean singleTransaction, int commitAfterEveryInserts, boolean deleteExistingData, ImportProgressCtrl importProgressCtrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Thread.UncaughtExceptionHandler createUncaughtExceptionHandler() {
        return (t, e) -> GUIUtils.processOnSwingEventThread(() -> {
            throw new RuntimeException(e);
        });
    }

    private void finishTransaction(ISQLConnection conn, boolean success) {
        try {
            if (success) {
                conn.commit();
            } else {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                s_log.error("Finally failed to rollback connection");
            }
            throw new RuntimeException(e);
        }
    }

    private void setOriginalAutoCommit(ISQLConnection conn, boolean originalAutoCommit) {
        try {
            conn.setAutoCommit(originalAutoCommit);
        }
        catch (SQLException e) {
            EDTMessageBoxUtil.showMessageDialogOnEDT(s_stringMgr.getString("ImportDataIntoTableExecutor.reestablish.autocommit.failed"), s_stringMgr.getString("ImportDataIntoTableExecutor.reestablish.autocommit.failed.title"), 0);
            throw new RuntimeException(e);
        }
    }

    private boolean getOriginalAutoCommit(ISQLConnection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void bindAutoincrementColumn(PreparedStatement stmt, int index, ExtendedColumnInfo column, int counter) throws SQLException, UnsupportedFormatException {
        long value = 0L;
        String fixedValue = this._columnMappingModel.getFixedValue(column);
        try {
            value = Long.parseLong(fixedValue);
            value += (long)counter;
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedFormatException("Could not interpret value for column " + column.getColumnName() + " as value of type long. The value is: " + fixedValue, nfe);
        }
        switch (column.getTableColumnInfo().getDataType()) {
            case -5: {
                stmt.setLong(index, value);
                break;
            }
            case 2: 
            case 4: {
                stmt.setInt(index, (int)value);
                break;
            }
            default: {
                throw new UnsupportedFormatException("Autoincrement column " + column.getColumnName() + "  is not numeric");
            }
        }
    }

    private void bindFixedColumn(PreparedStatement stmt, int index, ExtendedColumnInfo column) throws SQLException, IOException, UnsupportedFormatException {
        String value = this._columnMappingModel.getFixedValue(column);
        Object d = null;
        switch (column.getTableColumnInfo().getDataType()) {
            case -5: {
                try {
                    stmt.setLong(index, Long.parseLong(value));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new UnsupportedFormatException(nfe);
                }
            }
            case 4: {
                this.setIntOrUnsignedInt(stmt, index, column, null != value ? Integer.valueOf(Integer.parseInt(value)) : null, null != value ? Long.valueOf(Long.parseLong(value)) : null);
            }
            case 2: {
                this.setDouble(stmt, index, null != value ? Double.valueOf(Double.parseDouble(value)) : null, 8);
                break;
            }
            case 91: {
                this.setDateOrNull(stmt, index, value);
                break;
            }
            case 93: {
                this.setTimeStampOrNull(stmt, index, value);
                break;
            }
            case 92: {
                this.setTimeOrNull(stmt, index, value);
                break;
            }
            default: {
                stmt.setString(index, value);
            }
        }
    }

    private void setDateOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setDate(index, new Date(d.getTime()));
        } else {
            stmt.setNull(index, 91);
        }
    }

    private void setTimeStampOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setTimestamp(index, new Timestamp(d.getTime()));
        } else {
            stmt.setNull(index, 93);
        }
    }

    private void setTimeOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setTime(index, new Time(d.getTime()));
        } else {
            stmt.setNull(index, 92);
        }
    }

    private void bindColumn(PreparedStatement stmt, int index, ExtendedColumnInfo column) throws SQLException, IOException {
        int mappedColumn = this.getMappedColumn(column);
        switch (column.getTableColumnInfo().getDataType()) {
            case -5: {
                this.setLong(stmt, index, this._importer.getLong(mappedColumn));
                break;
            }
            case 4: 
            case 5: {
                this.setIntOrUnsignedInt(stmt, index, column, this._importer.getInt(mappedColumn), this._importer.getLong(mappedColumn));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                this.setDouble(stmt, index, this._importer.getDouble(this.getMappedColumn(column)), column.getTableColumnInfo().getDataType());
                break;
            }
            case 91: {
                this.setDate(stmt, index, mappedColumn);
                break;
            }
            case 93: {
                this.setTimestamp(stmt, index, mappedColumn);
                break;
            }
            case 92: {
                this.setTime(stmt, index, mappedColumn);
                break;
            }
            default: {
                this.setString(stmt, index, mappedColumn);
            }
        }
    }

    private void setString(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException {
        String string = this._importer.getString(mappedColumn);
        if (null != string) {
            stmt.setString(index, string);
        } else {
            stmt.setNull(index, 12);
        }
    }

    private void setTime(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException {
        java.util.Date date = this._importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setTime(index, new Time(date.getTime()));
        } else {
            stmt.setNull(index, 92);
        }
    }

    private void setTimestamp(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException {
        java.util.Date date = this._importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setTimestamp(index, new Timestamp(date.getTime()));
        } else {
            stmt.setNull(index, 93);
        }
    }

    private void setDate(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException {
        java.util.Date date = this._importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setDate(index, new Date(date.getTime()));
        } else {
            stmt.setNull(index, 91);
        }
    }

    private void setIntOrUnsignedInt(PreparedStatement stmt, int index, ExtendedColumnInfo column, Integer integerValue, Long longValue) throws SQLException {
        String columnTypeName = column.getTableColumnInfo().getTypeName();
        if (columnTypeName != null && columnTypeName.toUpperCase().endsWith("UNSIGNED")) {
            this.setLong(stmt, index, longValue);
        }
        this.setInt(stmt, index, integerValue);
    }

    private void setDouble(PreparedStatement stmt, int index, Double value, int javaSqlTypes_Type) throws SQLException {
        if (null == value) {
            stmt.setNull(index, javaSqlTypes_Type);
        } else {
            stmt.setDouble(index, value);
        }
    }

    private void setLong(PreparedStatement stmt, int index, Long value) throws SQLException {
        if (null == value) {
            stmt.setNull(index, 4);
        } else {
            stmt.setLong(index, value);
        }
    }

    private void setInt(PreparedStatement stmt, int index, Integer value) throws SQLException {
        if (null == value) {
            stmt.setNull(index, 4);
        } else {
            stmt.setInt(index, value);
        }
    }

    private int getMappedColumn(ExtendedColumnInfo column) {
        return this._importerColumns.indexOf(this._columnMappingModel.getMapping(column));
    }

    private String createColumnList() {
        StringBuffer columnsList = new StringBuffer();
        for (ExtendedColumnInfo column : this._columns) {
            String mapping = this._columnMappingModel.getMapping(column);
            if (SpecialColumnMapping.SKIP.getVisibleString().equals(mapping)) continue;
            if (columnsList.length() != 0) {
                columnsList.append(", ");
            }
            columnsList.append(column.getColumnName());
        }
        return columnsList.toString();
    }

    private String getQuestionMarks(int count) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            result.append("?");
            if (i >= count - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

