/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.ImportProgressDialog;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.UnsupportedFormatException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ImportProgressCtrl {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportProgressCtrl.class);
    private static final ILogger log = LoggerController.createLogger(ImportProgressCtrl.class);
    private final ImportProgressDialog _dlg;
    private ITableInfo _table;
    private volatile int _currentRow;
    private volatile boolean _canceled;
    private final Timer _timer;

    public ImportProgressCtrl(ITableInfo table) {
        this._dlg = new ImportProgressDialog(table.getSimpleName());
        this._table = table;
        this._timer = new Timer(300, e -> this._dlg.txtNumberOfRowsImported.setText("" + this._currentRow));
        this._timer.setRepeats(true);
        this._timer.start();
        this._dlg.btnCancel.addActionListener(e -> this.onCanceled());
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onCanceled() {
        this._canceled = true;
    }

    public void setCurrentRow(int currentRow) {
        this._currentRow = currentRow;
    }

    public void finishedSuccessFully() {
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.inserted", this._currentRow, this._table.getSimpleName()));
    }

    public void failedWithSQLException(SQLException sqle, PreparedStatement stmt, StringBuffer insertSQL) {
        String query = stmt == null ? "null" : stmt.toString();
        log.error("Failing query: " + query);
        log.error("Failing INSERT statement: " + insertSQL);
        log.error("Failing line in CVS file: " + this._currentRow);
        log.error("Database error", sqle);
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.sqlException", Utilities.getExceptionStringSave(sqle), Integer.toString(this._currentRow)), stringMgr.getString("ImportDataIntoTableExecutor.error"));
    }

    public void failedWithIoException(IOException ioe) {
        log.error("Error while reading file", ioe);
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.ioException", Utilities.getExceptionStringSave(ioe), this._currentRow), stringMgr.getString("ImportDataIntoTableExecutor.error"));
    }

    public void failedWithUnsupportedFormatException(UnsupportedFormatException ufe) {
        log.error("Unsupported format.", ufe);
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.UnsupportedFormatException", Utilities.getExceptionStringSave(ufe), this._currentRow), stringMgr.getString("ImportDataIntoTableExecutor.error"));
    }

    public void failedWithUnknownException(Throwable t) {
        log.error("Unsupported format.", t);
        GUIUtils.processOnSwingEventThread(() -> this.close());
        EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.UnknownException", Utilities.getExceptionStringSave(t), this._currentRow), stringMgr.getString("ImportDataIntoTableExecutor.error"));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void close() {
        this._timer.stop();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }
}

