/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ImportFileChooserDialog
extends JDialog {
    private static final String PREFS_KEY_LAST_IMPORT_DIRECTORY = "squirrelsql_dataimport_last_import_directory";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportFileChooserDialog.class);
    private JFileChooser _fileChooser;
    private JButton _btnClipBoard;
    private File _importFile;
    private boolean _importFromClipBoard;

    public ImportFileChooserDialog(IResources resources, ITableInfo table) {
        super((Frame)Main.getApplication().getMainFrame(), true);
        if (null == table) {
            this.setTitle(s_stringMgr.getString("ImportTableDataCommand.file.dialog.title.without.table"));
        } else {
            this.setTitle(s_stringMgr.getString("ImportTableDataCommand.file.dialog.title.with.table", table));
        }
        this.buildUI(resources);
        this._fileChooser.addActionListener(e -> this.onFileChooserButtonClicked(e.getActionCommand()));
        this._btnClipBoard.addActionListener(e -> this.onImportFromClipBoard());
        GUIUtils.enableCloseByEscape(this);
        this.pack();
        GUIUtils.centerWithinParent(this);
        this.setVisible(true);
    }

    public File getImportFile() {
        return this._importFile;
    }

    public boolean isImportFromClipBoard() {
        return this._importFromClipBoard;
    }

    private void onImportFromClipBoard() {
        this._importFromClipBoard = true;
        this.close();
    }

    private void onFileChooserButtonClicked(String actionCommand) {
        if ("ApproveSelection".equals(actionCommand)) {
            this._importFile = this._fileChooser.getSelectedFile();
            if (null != this._importFile.getParent()) {
                Props.putString(PREFS_KEY_LAST_IMPORT_DIRECTORY, this._importFile.getParent());
            }
        }
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void buildUI(IResources resources) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this._fileChooser = new JFileChooser(Props.getString(PREFS_KEY_LAST_IMPORT_DIRECTORY, System.getProperty("user.home")));
        this.getContentPane().add((Component)this._fileChooser, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnClipBoard = new JButton(s_stringMgr.getString("ImportFileChooserDialog.import.from.clipboard"), resources.getIcon("clipboard"));
        this.getContentPane().add((Component)this._btnClipBoard, gbc);
    }
}

