/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.ImportFileType;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.ImportFileUtils;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.action.FileDisplayWrapper;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.action.ImportFileChooserDialog;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportFileDialogCtrl;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.ConfigurationPanel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.FileImporterFactory;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ImportTableDataCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportTableDataCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(ImportTableDataCommand.class);
    private ISession _session;
    private IResources _resources;
    private ITableInfo _table;

    public ImportTableDataCommand(ISession session, IResources resources) {
        this(session, resources, null);
    }

    public ImportTableDataCommand(ISession session, IResources resources, ITableInfo table) {
        this._session = session;
        this._resources = resources;
        this._table = table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        try {
            ImportFileType type;
            IFileImporter importer;
            ConfigurationPanel configurationPanel;
            FileDisplayWrapper fileDisplayWrapper;
            ImportFileChooserDialog importFileChooser = new ImportFileChooserDialog(this._resources, this._table);
            if (importFileChooser.isImportFromClipBoard()) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable tran = clipboard.getContents(null);
                if (tran != null && tran.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)tran.getTransferData(DataFlavor.javaFileListFlavor);
                    if (fileList.isEmpty() || null == fileList.get(0)) {
                        return;
                    }
                    fileDisplayWrapper = new FileDisplayWrapper((File)fileList.get(0), false);
                } else {
                    if (tran == null || !tran.isDataFlavorSupported(DataFlavor.stringFlavor)) throw new IllegalStateException("Failed to interpret clipboard as string or file");
                    String clipContent = (String)tran.getTransferData(DataFlavor.stringFlavor);
                    Path tempFile = Files.createTempFile("squirrel-clipboard-import", ".csv", new FileAttribute[0]);
                    tempFile.toFile().deleteOnExit();
                    try (BufferedWriter writer = Files.newBufferedWriter(tempFile, new OpenOption[0]);){
                        writer.write(clipContent);
                    }
                    fileDisplayWrapper = new FileDisplayWrapper(tempFile.toFile(), true);
                }
            } else {
                if (null == importFileChooser.getImportFile()) {
                    return;
                }
                fileDisplayWrapper = new FileDisplayWrapper(importFileChooser.getImportFile(), false);
            }
            if ((configurationPanel = (importer = FileImporterFactory.createImporter(type = ImportFileUtils.determineType(fileDisplayWrapper.getFile()), fileDisplayWrapper.getFile())).createConfigurationPanel()) != null) {
                JDialog dialog = new JDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("ImportTableDataCommand.settingsDialogTitle"), true);
                StateListener dialogState = new StateListener(dialog);
                dialog.setLayout(new BorderLayout());
                dialog.add((Component)configurationPanel, "Center");
                OkClosePanel buttons = new OkClosePanel();
                buttons.getCloseButton().setText(s_stringMgr.getString("ImportTableDataCommand.cancel"));
                buttons.addListener(dialogState);
                dialog.add((Component)buttons, "South");
                dialog.pack();
                GUIUtils.centerWithinParent(dialog);
                dialog.setVisible(true);
                if (!dialogState.isOkPressed()) return;
                configurationPanel.apply();
            }
            ImportFileDialogCtrl importFileDialogCtrl = new ImportFileDialogCtrl(this._session, fileDisplayWrapper, importer, this._table);
            importFileDialogCtrl.setPreviewData(importer.getPreview(10));
            importFileDialogCtrl.show();
            return;
        }
        catch (Exception e) {
            s_log.error("execute: unexpected exception - " + e.getMessage(), e);
            EDTMessageBoxUtil.showMessageDialogOnEDT(s_stringMgr.getString("ImportTableDataCommand.ioErrorOccured"), s_stringMgr.getString("ImportTableDataCommand.error"));
        }
    }

    private class StateListener
    implements IOkClosePanelListener {
        private boolean okPressed = false;
        private JDialog dialog = null;

        public StateListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void cancelPressed(OkClosePanelEvent evt) {
        }

        @Override
        public void closePressed(OkClosePanelEvent evt) {
            this.okPressed = false;
            this.dialog.dispose();
        }

        @Override
        public void okPressed(OkClosePanelEvent evt) {
            this.okPressed = true;
            this.dialog.dispose();
        }

        public boolean isOkPressed() {
            return this.okPressed;
        }
    }
}

