/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportPropsDAO;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ColumnGuess {
    private String _columnName;
    private int _varcharLength;
    private boolean _suggestColumnTypes;
    private String _type;
    private int _numericPrecision;
    private int _numericScale;

    public ColumnGuess(String columnName, int varcharLength, int numericPrecision, int numericScale, boolean suggestColumnTypes, HashSet<String> duplicateColumnNameCheck) {
        this._varcharLength = varcharLength;
        this._numericPrecision = numericPrecision;
        this._numericScale = numericScale;
        this._suggestColumnTypes = suggestColumnTypes;
        Object colNameBuf = columnName;
        int i = 0;
        while (duplicateColumnNameCheck.contains(((String)colNameBuf).toLowerCase())) {
            colNameBuf = columnName + i;
            ++i;
        }
        this._columnName = colNameBuf;
        duplicateColumnNameCheck.add(this._columnName.toLowerCase());
    }

    private String getDefaultType() {
        return "VARCHAR(" + this._varcharLength + ")";
    }

    public void exampleValue(String val) {
        if (!this._suggestColumnTypes) {
            this._type = this.getDefaultType();
        }
        if (StringUtilities.isEmpty(val)) {
            return;
        }
        if (null == this._type || "INTEGER".equals(this._type)) {
            try {
                Integer.parseInt(val);
                this._type = "INTEGER";
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null == this._type || "INTEGER".equals(this._type) || this.getNumericType().equals(this._type)) {
            try {
                Double.parseDouble(val);
                this._type = this.getNumericType();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (null == this._type || "INTEGER".equals(this._type) || this.getNumericType().equals(this._type) || "TIMESTAMP".equals(this._type)) {
            try {
                new SimpleDateFormat(ImportPropsDAO.getCSVDateFormat()).parse(val);
                this._type = "TIMESTAMP";
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this._type = this.getDefaultType();
    }

    private String getNumericType() {
        return "NUMERIC(" + this._numericPrecision + "," + this._numericScale + ")";
    }

    public String getColumnSQL() {
        return this._columnName + " " + (null != this._type ? this._type : this.getDefaultType());
    }
}

