/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColumnMappingTableModel
extends AbstractTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColumnMappingTableModel.class);
    private ExtendedColumnInfo[] _columns;
    private Vector<String> _mapping = new Vector();
    private Vector<String> _defaults = new Vector();

    public ColumnMappingTableModel(ExtendedColumnInfo[] columns) {
        this._columns = columns;
        for (int i = 0; i < columns.length; ++i) {
            this._mapping.add(SpecialColumnMapping.SKIP.getVisibleString());
            this._defaults.add("");
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this._columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this._columns[rowIndex].getColumnName();
        }
        if (columnIndex == 1) {
            return this._mapping.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this._defaults.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this._mapping.set(row, value.toString());
        } else if (col == 2) {
            this._defaults.set(row, value.toString());
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return s_stringMgr.getString("ImportFileDialog.tableColumn");
        }
        if (column == 1) {
            return s_stringMgr.getString("ImportFileDialog.importFileColumn");
        }
        if (column == 2) {
            return s_stringMgr.getString("ImportFileDialog.fixedValue");
        }
        return null;
    }

    public int findTableColumn(String columnName) {
        int i = 0;
        for (i = 0; i < this._columns.length; ++i) {
            if (!columnName.equals(this._columns[i].getColumnName())) continue;
            return i;
        }
        return -1;
    }

    public void resetMappings() {
        this._mapping.clear();
        this._defaults.clear();
        for (int i = 0; i < this._columns.length; ++i) {
            this._mapping.add(SpecialColumnMapping.SKIP.getVisibleString());
            this._defaults.add("");
        }
        this.fireTableDataChanged();
    }

    public String getMapping(ExtendedColumnInfo column) {
        int pos = this.findTableColumn(column.getColumnName());
        return this.getValueAt(pos, 1).toString();
    }

    public String getFixedValue(ExtendedColumnInfo column) {
        int pos = this.findTableColumn(column.getColumnName());
        return this.getValueAt(pos, 2).toString();
    }

    public int getColumnCountExcludingSkipped(ExtendedColumnInfo[] columns) {
        int count = 0;
        for (ExtendedColumnInfo column : columns) {
            int pos = this.findTableColumn(column.getColumnName());
            String mapping = this.getValueAt(pos, 1).toString();
            if (SpecialColumnMapping.SKIP.getVisibleString().equals(mapping)) continue;
            ++count;
        }
        return count;
    }
}

