/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.action.FileDisplayWrapper;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ImportFileDialog
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportFileDialog.class);
    JTable tblPreview;
    JTable tblMapping;
    JCheckBox chkHeadersIncluded;
    JToggleButton btnSuggestNewTable;
    JTextField txtTableName;
    JButton btnShowTableDetails;
    JButton btnCreateTable;
    JToggleButton btnSuggestColumns;
    JToggleButton btnOneToOneMapping;
    JCheckBox chkEmptyTableBeforeImport;
    JLabel lblEmptyTableWarning;
    JCheckBox chkTrimValues;
    JCheckBox chkSafeMode;
    OkClosePanel btnsPnl = new OkClosePanel();
    JCheckBox chkSingleTransaction;
    JFormattedTextField txtCommitAfterInserts;
    JLabel lblCommitAfterInsertBegin;
    JLabel lblCommitAfterInsertEnd;

    public ImportFileDialog(FileDisplayWrapper importFile, String importFileTypeDescription, ITableInfo table) {
        super("", true);
        String tableName = s_stringMgr.getString("ImportFileDialogCtrl.no.table");
        if (null != table) {
            tableName = table.getSimpleName();
        }
        this.setTitle(this.createTitle(importFileTypeDescription, tableName));
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(importFile, table), "Center");
        this.setContentPane(content);
        this.btnsPnl.makeOKButtonDefault();
        this.btnsPnl.getRootPane().setDefaultButton(this.btnsPnl.getOKButton());
    }

    private String createTitle(String importFileTypeDescription, String tableName) {
        return s_stringMgr.getString("ImportFileDialog.title", importFileTypeDescription, tableName);
    }

    public void setImportDialogTitle(String importFileTypeDescription, String tableName) {
        super.setTitle(this.createTitle(importFileTypeDescription, tableName));
    }

    private Component createMainPanel(FileDisplayWrapper importFile, ITableInfo table) {
        this.tblPreview = new JTable();
        this.tblPreview.setAutoResizeMode(0);
        this.tblMapping = new JTable();
        this.chkHeadersIncluded = new JCheckBox(s_stringMgr.getString("ImportFileDialog.headersIncluded"));
        this.chkHeadersIncluded.setToolTipText(s_stringMgr.getString("ImportFileDialog.headersIncluded.tooltip"));
        this.chkHeadersIncluded.setSelected(true);
        this.chkTrimValues = new JCheckBox(s_stringMgr.getString("ImportFileDialog.trim.values"));
        this.chkTrimValues.setToolTipText(s_stringMgr.getString("ImportFileDialog.trim.values.tooltip"));
        this.chkTrimValues.setSelected(true);
        this.chkSafeMode = new JCheckBox(s_stringMgr.getString("ImportFileDialog.safetySwitch"));
        this.chkSafeMode.setSelected(true);
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ImportFileDialog.dataPreview", importFile.getDisplayPath())), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkHeadersIncluded, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)new JScrollPane(this.tblPreview), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createToggleButtonsPanel(table), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createEmptyTablePanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkTrimValues, gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createTransactionPanel(), gbc);
        gbc = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkSafeMode, gbc);
        gbc = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)new JScrollPane(this.tblMapping), gbc);
        gbc = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.btnsPnl, gbc);
        return ret;
    }

    private JPanel createToggleButtonsPanel(ITableInfo table) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.createSuggestTablePanel(table), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0);
        ret.add((Component)this.createColumnButtonsPanel(), gbc);
        return ret;
    }

    private JPanel createSuggestTablePanel(ITableInfo table) {
        GridBagConstraints gbc;
        JPanel ret = new JPanel(new GridBagLayout());
        int gridY = 0;
        if (null != table) {
            gbc = new GridBagConstraints(0, gridY, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
            JLabel lblInsertingInto = new JLabel(s_stringMgr.getString("ImportFileDialog.InsertingInto", table.getSimpleName()));
            lblInsertingInto.setFont(lblInsertingInto.getFont().deriveFont(1));
            ret.add((Component)lblInsertingInto, gbc);
            ++gridY;
        }
        gbc = new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.btnSuggestNewTable = new JToggleButton(s_stringMgr.getString("ImportFileDialog.suggestNewTable"));
        this.btnSuggestNewTable.setToolTipText(s_stringMgr.getString("ImportFileDialog.suggestNewTable"));
        this.btnSuggestNewTable.setSelected(false);
        ret.add((Component)this.btnSuggestNewTable, gbc);
        gbc = new GridBagConstraints(1, gridY, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0);
        this.txtTableName = new JTextField();
        this.txtTableName.setBorder(BorderFactory.createEtchedBorder());
        ret.add((Component)this.txtTableName, gbc);
        gbc = new GridBagConstraints(2, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.btnShowTableDetails = new JButton("...");
        this.btnShowTableDetails.setToolTipText(s_stringMgr.getString("ImportFileDialog.show.table.details.tooltip"));
        ret.add((Component)this.btnShowTableDetails, gbc);
        gbc = new GridBagConstraints(3, gridY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        this.btnCreateTable = new JButton(s_stringMgr.getString("ImportFileDialog.create.table"));
        this.btnCreateTable.setToolTipText(s_stringMgr.getString("ImportFileDialog.create.table.tooltip"));
        ret.add((Component)this.btnCreateTable, gbc);
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("ImportFileDialog.panel.title.import.table.creation")));
        return ret;
    }

    private JPanel createColumnButtonsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnSuggestColumns = new JToggleButton(s_stringMgr.getString("ImportFileDialog.suggestColumns"));
        this.btnSuggestColumns.setToolTipText(s_stringMgr.getString("ImportFileDialog.suggestColumns.tooltip"));
        this.btnSuggestColumns.setSelected(false);
        ret.add((Component)this.btnSuggestColumns, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.btnOneToOneMapping = new JToggleButton(s_stringMgr.getString("ImportFileDialog.oneToOneMapping"));
        this.btnOneToOneMapping.setToolTipText(s_stringMgr.getString("ImportFileDialog.oneToOneMapping.tooltip"));
        this.btnOneToOneMapping.setSelected(false);
        ret.add((Component)this.btnOneToOneMapping, gbc);
        return ret;
    }

    private JPanel createEmptyTablePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkEmptyTableBeforeImport = new JCheckBox(s_stringMgr.getString("ImportFileDialog.empty.table"));
        ret.add((Component)this.chkEmptyTableBeforeImport, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0);
        this.lblEmptyTableWarning = new JLabel();
        this.lblEmptyTableWarning.setFont(this.lblEmptyTableWarning.getFont().deriveFont(1));
        this.lblEmptyTableWarning.setForeground(Color.red);
        ret.add((Component)this.lblEmptyTableWarning, gbc);
        return ret;
    }

    private JPanel createTransactionPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkSingleTransaction = new JCheckBox(s_stringMgr.getString("ImportFileDialog.singleTransaction"));
        ret.add((Component)this.chkSingleTransaction, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.lblCommitAfterInsertBegin = new JLabel(s_stringMgr.getString("ImportFileDialog.commitAfterInsert.begin"));
        ret.add((Component)this.lblCommitAfterInsertBegin, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtCommitAfterInserts = new JFormattedTextField(NumberFormat.getInstance());
        this.txtCommitAfterInserts.setColumns(7);
        ret.add((Component)this.txtCommitAfterInserts, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.lblCommitAfterInsertEnd = new JLabel(s_stringMgr.getString("ImportFileDialog.commitAfterInsert.end"));
        ret.add((Component)this.lblCommitAfterInsertEnd, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        this.chkSingleTransaction.setSelected(true);
        return ret;
    }
}

