/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.ImportDataIntoTableExecutor;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.action.FileDisplayWrapper;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ColumnMappingTableModel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportFileDialog;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportPropsDAO;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.TableCreateUtils;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.TableSuggestion;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.CSVFileImporter;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ImportFileDialogCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportFileDialogCtrl.class);
    private final ImportFileDialog _importFileDialog;
    private String[][] _previewData = null;
    private List<String> _importerColumns = new ArrayList<String>();
    private ISession _session;
    private FileDisplayWrapper _importFile;
    private IFileImporter _importer;
    private ITableInfo _table;
    private TableSuggestion _tableSuggestion;

    public ImportFileDialogCtrl(ISession session, FileDisplayWrapper importFile, IFileImporter importer, ITableInfo table) {
        this._session = session;
        this._importFile = importFile;
        this._importer = importer;
        this._table = table;
        this._tableSuggestion = new TableSuggestion(this._session, createdTableInfo -> this.onTableCreated(createdTableInfo));
        this._importFileDialog = new ImportFileDialog(this._importFile, this._importer.getImportFileTypeDescription(), this._table);
        this._importFileDialog.setSize(this.getDimension());
        this._importFileDialog.addWidgetListener(new WidgetAdapter(){

            @Override
            public boolean widgetClosing(WidgetEvent evt) {
                ImportFileDialogCtrl.this.onClosing();
                return true;
            }
        });
        this._importFileDialog.btnsPnl.addListener(new IOkClosePanelListener(){

            @Override
            public void okPressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.onOk();
            }

            @Override
            public void closePressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.close();
            }

            @Override
            public void cancelPressed(OkClosePanelEvent evt) {
                ImportFileDialogCtrl.this.close();
            }
        });
        this._importFileDialog.chkHeadersIncluded.setSelected(ImportPropsDAO.isHeadersIncluded());
        this._importFileDialog.chkHeadersIncluded.addActionListener(e -> this.onHeadersIncluded());
        this.onHeadersIncluded();
        this._importFileDialog.btnSuggestColumns.addActionListener(e -> this.suggestColumns());
        this._importFileDialog.btnOneToOneMapping.addActionListener(e -> this.mapOneToOne());
        this._importFileDialog.txtCommitAfterInserts.setText("" + ImportPropsDAO.getCommitAfterInsertsCount());
        this._importFileDialog.chkSingleTransaction.setSelected(ImportPropsDAO.isSingleTransaction());
        this._importFileDialog.chkSingleTransaction.addActionListener(e -> this.updateTransactionPanel());
        this.updateTransactionPanel();
        this._importFileDialog.chkEmptyTableBeforeImport.setSelected(ImportPropsDAO.isEmptyTableOnImport());
        this._importFileDialog.chkEmptyTableBeforeImport.addActionListener(e -> this.onEmptyTableBeforeImport());
        this.onEmptyTableBeforeImport();
        this._importFileDialog.chkTrimValues.setSelected(ImportPropsDAO.isTrimValues());
        this._importFileDialog.chkSafeMode.setSelected(ImportPropsDAO.isSaveMode());
        this._importFileDialog.btnSuggestNewTable.addActionListener(e -> this.onSuggestNewTable());
        this.onSuggestNewTable();
        this._importFileDialog.btnShowTableDetails.addActionListener(e -> this.onShowTableDetails());
        this._importFileDialog.btnCreateTable.addActionListener(e -> this.onCreateTable());
        GUIUtils.enableCloseByEscape(this._importFileDialog);
    }

    private void onCreateTable() {
        if (!this.checkTableName()) {
            return;
        }
        this._tableSuggestion.execCreateTableInDatabase(this._importFileDialog.txtTableName.getText());
    }

    private void onShowTableDetails() {
        if (!this.checkTableName()) {
            return;
        }
        Window owningWindow = GUIUtils.getOwningWindow(this._importFileDialog.getContentPane());
        this._tableSuggestion.showTableDialog(owningWindow, this._importFileDialog.txtTableName.getText());
    }

    private boolean checkTableName() {
        if (StringUtilities.isEmpty(this._importFileDialog.txtTableName.getText(), true)) {
            JOptionPane.showMessageDialog(this._importFileDialog.getContentPane(), s_stringMgr.getString("ImportFileDialogCtrl.please.enter.table.name"));
            return false;
        }
        return true;
    }

    private void onTableCreated(ITableInfo createdTableInfo) {
        this._table = createdTableInfo;
        this._importFileDialog.setImportDialogTitle(this._importer.getImportFileTypeDescription(), this._table.getSimpleName());
        this.updatePreviewAndMapping();
    }

    private void onSuggestNewTable() {
        if (this._importFileDialog.btnSuggestNewTable.isSelected()) {
            this._importFileDialog.txtTableName.setEnabled(true);
            this._importFileDialog.txtTableName.setText(TableCreateUtils.suggestTableName(this._importFile));
            this._importFileDialog.btnShowTableDetails.setEnabled(true);
            this._importFileDialog.btnCreateTable.setEnabled(true);
        } else {
            this._importFileDialog.txtTableName.setEnabled(false);
            this._importFileDialog.txtTableName.setText(null);
            this._importFileDialog.btnShowTableDetails.setEnabled(false);
            this._importFileDialog.btnCreateTable.setEnabled(false);
            this._tableSuggestion.clear();
        }
    }

    private void onEmptyTableBeforeImport() {
        if (this._importFileDialog.chkEmptyTableBeforeImport.isSelected()) {
            this._importFileDialog.lblEmptyTableWarning.setText(s_stringMgr.getString("ImportFileDialogCtrl.all.data.will.be.lost.warning"));
        } else {
            this._importFileDialog.lblEmptyTableWarning.setText(null);
        }
    }

    private void onHeadersIncluded() {
        this._importFileDialog.btnSuggestColumns.setSelected(false);
        this.updatePreviewAndMapping();
    }

    private Dimension getDimension() {
        return new Dimension(ImportPropsDAO.getDialogWidth(), ImportPropsDAO.getDialogHeight());
    }

    public void onClosing() {
        Dimension size = this._importFileDialog.getSize();
        ImportPropsDAO.setDialogWidth(size.width);
        ImportPropsDAO.setDialogHeight(size.height);
        ImportPropsDAO.setCommitAfterInsertsCount(this.getCommitAfterEveryInsertsCount());
        ImportPropsDAO.setEmptyTableOnImport(this._importFileDialog.chkEmptyTableBeforeImport.isSelected());
        ImportPropsDAO.setHeadersIncluded(this._importFileDialog.chkHeadersIncluded.isSelected());
        ImportPropsDAO.setSingleTransaction(this._importFileDialog.chkSingleTransaction.isSelected());
        ImportPropsDAO.setTrimValues(this._importFileDialog.chkTrimValues.isSelected());
        ImportPropsDAO.setSaveMode(this._importFileDialog.chkSafeMode.isSelected());
    }

    private void updateTransactionPanel() {
        boolean intermediateCommits = false == this._importFileDialog.chkSingleTransaction.isSelected();
        this._importFileDialog.txtCommitAfterInserts.setEnabled(intermediateCommits);
        this._importFileDialog.lblCommitAfterInsertBegin.setEnabled(intermediateCommits);
        this._importFileDialog.lblCommitAfterInsertEnd.setEnabled(intermediateCommits);
    }

    public void setPreviewData(String[][] data) {
        this._previewData = data;
        this.updatePreviewAndMapping();
    }

    private void updatePreviewAndMapping() {
        JComboBox<String> cboColumnMapping = new JComboBox<String>();
        cboColumnMapping.addItem(SpecialColumnMapping.SKIP.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.FIXED_VALUE.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString());
        cboColumnMapping.addItem(SpecialColumnMapping.NULL.getVisibleString());
        cboColumnMapping.addActionListener(e -> this.onColumnMappingSelected(e));
        if (this._previewData != null && this._previewData.length > 0) {
            int i;
            Object[] headers = new String[this._previewData[0].length];
            Object[][] data = this._previewData;
            if (this._importFileDialog.chkHeadersIncluded.isSelected()) {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = data[0][i];
                }
                data = new String[this._previewData.length - 1][];
                for (i = 1; i < this._previewData.length; ++i) {
                    data[i - 1] = this._previewData[i];
                }
            } else {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = s_stringMgr.getString("ImportFileDialog.column") + i;
                }
            }
            this._importerColumns.clear();
            for (i = 0; i < headers.length; ++i) {
                this._importerColumns.add(headers[i]);
            }
            for (String string : headers) {
                cboColumnMapping.addItem(string);
            }
            DefaultTableModel dataModel = new DefaultTableModel(data, headers){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this._importFileDialog.tblPreview.setModel(dataModel);
        }
        this._tableSuggestion.updatePreviewData(this._previewData, this._importFileDialog.chkHeadersIncluded.isSelected());
        this.updateMapping(cboColumnMapping);
    }

    private void updateMapping(JComboBox cboColumnMapping) {
        if (null == this._table) {
            return;
        }
        ExtendedColumnInfo[] createdTableColumns = this.getExtendedColumnInfos();
        this._importFileDialog.tblMapping.setModel(new ColumnMappingTableModel(createdTableColumns));
        if (null != this._importFileDialog.tblMapping.getColumnModel().getColumn(1).getCellEditor()) {
            this._importFileDialog.tblMapping.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
        }
        this._importFileDialog.tblMapping.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(cboColumnMapping));
        ((ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel()).resetMappings();
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            this.suggestColumns();
        } else if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            this.mapOneToOne();
        }
    }

    private void onColumnMappingSelected(ActionEvent e) {
        int selectedRow = this._importFileDialog.tblMapping.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        TableModel model = this._importFileDialog.tblMapping.getModel();
        String comboValue = ((JComboBox)e.getSource()).getSelectedItem().toString();
        int fixedValueColumnIdx = 2;
        if (comboValue.equals(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString())) {
            if (model.getValueAt(selectedRow, fixedValueColumnIdx) == null || "".equals(model.getValueAt(selectedRow, fixedValueColumnIdx))) {
                model.setValueAt("0", selectedRow, fixedValueColumnIdx);
            }
        } else if (!comboValue.equals(SpecialColumnMapping.FIXED_VALUE.getVisibleString())) {
            model.setValueAt("", selectedRow, fixedValueColumnIdx);
        }
        this._importFileDialog.tblMapping.clearSelection();
    }

    private void mapOneToOne() {
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            this._importFileDialog.btnSuggestColumns.setSelected(false);
        }
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel();
        if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            columnMappingTableModel.resetMappings();
            ExtendedColumnInfo[] columns = this.getExtendedColumnInfos();
            for (int i = 0; i < Math.min(this._importerColumns.size(), columns.length); ++i) {
                String importerColumn = this._importerColumns.get(i);
                if (StringUtilities.isEmpty(importerColumn, true)) continue;
                columnMappingTableModel.setValueAt(importerColumn, i, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    public void suggestColumns() {
        if (this._importFileDialog.btnOneToOneMapping.isSelected()) {
            this._importFileDialog.btnOneToOneMapping.setSelected(false);
        }
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel();
        if (this._importFileDialog.btnSuggestColumns.isSelected()) {
            columnMappingTableModel.resetMappings();
            for (String importerColumn : this._importerColumns) {
                ExtendedColumnInfo suggestedColumn;
                if (null == importerColumn || importerColumn.isEmpty() || (suggestedColumn = this.suggestColumn(importerColumn)) == null) continue;
                String suggestedColumnName = suggestedColumn.getColumnName();
                int row = columnMappingTableModel.findTableColumn(suggestedColumnName);
                columnMappingTableModel.setValueAt(importerColumn, row, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    private ExtendedColumnInfo suggestColumn(String importerColumn) {
        ExtendedColumnInfo[] columns;
        for (ExtendedColumnInfo colInfo : columns = this.getExtendedColumnInfos()) {
            if (!colInfo.getColumnName().equalsIgnoreCase(importerColumn) && !colInfo.getColumnName().equalsIgnoreCase(StringUtilities.javaNormalize(importerColumn))) continue;
            return colInfo;
        }
        return null;
    }

    public void onOk() {
        ExtendedColumnInfo[] columns;
        ColumnMappingTableModel columnMappingModel;
        if (null == this._table) {
            String msg = s_stringMgr.getString("ImportFileDialogCtrl.no.table.msg");
            String title = s_stringMgr.getString("ImportFileDialogCtrl.no.table.title");
            EDTMessageBoxUtil.showMessageDialogOnEDT(msg, title);
            return;
        }
        if (null != this._importFileDialog.tblMapping.getCellEditor()) {
            this._importFileDialog.tblMapping.getCellEditor().stopCellEditing();
        }
        if (0 == (columnMappingModel = (ColumnMappingTableModel)this._importFileDialog.tblMapping.getModel()).getColumnCountExcludingSkipped(columns = this.getExtendedColumnInfos())) {
            String msg = s_stringMgr.getString("ImportFileDialogCtrl.all.columns.skipped.msg");
            String title = s_stringMgr.getString("ImportFileDialogCtrl.all.columns.skipped.title");
            EDTMessageBoxUtil.showMessageDialogOnEDT(msg, title);
            return;
        }
        this.close();
        if (this._importer instanceof CSVFileImporter) {
            ((CSVFileImporter)this._importer).setSafetySwitch(this._importFileDialog.chkSafeMode.isSelected());
        }
        this._importer.setTrimValues(this._importFileDialog.chkTrimValues.isSelected());
        int commitAfterEveryInsertsCount = this.getCommitAfterEveryInsertsCount();
        ImportDataIntoTableExecutor executor = new ImportDataIntoTableExecutor(this._session, this._table, this.getExtendedColumnInfos(), this._importerColumns, columnMappingModel, this._importer, this._importFileDialog.chkSingleTransaction.isSelected(), commitAfterEveryInsertsCount, this._importFileDialog.chkEmptyTableBeforeImport.isSelected());
        executor.setSkipHeader(this._importFileDialog.chkHeadersIncluded.isSelected());
        executor.execute();
    }

    private ExtendedColumnInfo[] getExtendedColumnInfos() {
        return this._session.getSchemaInfo().getExtendedColumnInfos(this._table.getCatalogName(), this._table.getSchemaName(), this._table.getSimpleName());
    }

    private int getCommitAfterEveryInsertsCount() {
        int commitAfterEveryInsertsCount = ImportPropsDAO.getCommitAfterInsertsCount();
        if (null != this._importFileDialog.txtCommitAfterInserts.getText()) {
            try {
                int buf = Integer.valueOf(this._importFileDialog.txtCommitAfterInserts.getText());
                if (commitAfterEveryInsertsCount >= 0) {
                    commitAfterEveryInsertsCount = buf;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return commitAfterEveryInsertsCount;
    }

    private void close() {
        this.onClosing();
        this._importFileDialog.setVisible(false);
        this._importFileDialog.dispose();
    }

    public void show() {
        Main.getApplication().getMainFrame().addWidget(this._importFileDialog);
        this._importFileDialog.moveToFront();
        DialogWidget.centerWithinDesktop(this._importFileDialog);
        this._importFileDialog.setVisible(true);
    }
}

