/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportPropsDAO;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportTableDetailsDialog;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.TableCreateUtils;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class ImportTableDetailsCtrl {
    private ImportTableDetailsDialog _importTableDetailsDialog;
    private final String _tableName;
    private final ISession _session;
    private final String[][] _previewData;
    private final boolean _headerIncluded;
    private boolean _isCreateTable;

    public ImportTableDetailsCtrl(Window owningWindow, ISession session, String[][] previewData, String tableName, boolean headerIncluded) {
        this._importTableDetailsDialog = new ImportTableDetailsDialog(owningWindow);
        this._tableName = tableName;
        this._session = session;
        this._previewData = previewData;
        this._headerIncluded = headerIncluded;
        this._importTableDetailsDialog.txtTableNamePattern.setText(ImportPropsDAO.getTableNamePattern());
        this._importTableDetailsDialog.chkSuggestColumnTypes.setSelected(ImportPropsDAO.isSuggestColumnTypes());
        this._importTableDetailsDialog.chkSuggestColumnTypes.addActionListener(e -> this.refreshSQL());
        this._importTableDetailsDialog.txtVarcharLength.setInt(ImportPropsDAO.getVarCharLength());
        this._importTableDetailsDialog.txtVarcharLength.getDocument().addDocumentListener(this.createRefreshSqlDocListener());
        this._importTableDetailsDialog.txtNumericPrecision.setInt(ImportPropsDAO.getNumericPrecision());
        this._importTableDetailsDialog.txtNumericPrecision.getDocument().addDocumentListener(this.createRefreshSqlDocListener());
        this._importTableDetailsDialog.txtNumericScale.setInt(ImportPropsDAO.getNumericScale());
        this._importTableDetailsDialog.txtNumericScale.getDocument().addDocumentListener(this.createRefreshSqlDocListener());
        this.refreshSQL();
        this._importTableDetailsDialog.btnCreateTable.addActionListener(e -> this.onCreateTable());
        this._importTableDetailsDialog.btnClose.addActionListener(e -> this.onClose());
        GUIUtils.initLocation(this._importTableDetailsDialog, 400, 400);
        GUIUtils.enableCloseByEscape(this._importTableDetailsDialog);
    }

    private DocumentListener createRefreshSqlDocListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportTableDetailsCtrl.this.refreshSQL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportTableDetailsCtrl.this.refreshSQL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportTableDetailsCtrl.this.refreshSQL();
            }
        };
    }

    private void refreshSQL() {
        this.savePrefs();
        String createSql = TableCreateUtils.suggestCreateScript(this._tableName, this._session, this._previewData, this._headerIncluded);
        this._importTableDetailsDialog.txtCreateTableSQL.setText(createSql);
        SwingUtilities.invokeLater(() -> this._importTableDetailsDialog.txtCreateTableSQL.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
    }

    public void showDialog() {
        this._importTableDetailsDialog.setVisible(true);
    }

    private void onCreateTable() {
        this._isCreateTable = true;
        this.onClose();
    }

    private void onClose() {
        this.savePrefs();
        this.close();
    }

    private void close() {
        this._importTableDetailsDialog.setVisible(false);
        this._importTableDetailsDialog.dispose();
    }

    private void savePrefs() {
        ImportPropsDAO.setTableNamePattern(this._importTableDetailsDialog.txtTableNamePattern.getText());
        ImportPropsDAO.setSuggestTypes(this._importTableDetailsDialog.chkSuggestColumnTypes.isSelected());
        ImportPropsDAO.setVarCharLength(this._importTableDetailsDialog.txtVarcharLength.getInt());
        ImportPropsDAO.setNumericPrecision(this._importTableDetailsDialog.txtNumericPrecision.getInt());
        ImportPropsDAO.setNumericScale(this._importTableDetailsDialog.txtNumericScale.getInt());
    }

    public boolean isCreateTable() {
        return this._isCreateTable;
    }

    public String getCreateSql() {
        return this._importTableDetailsDialog.txtCreateTableSQL.getText();
    }
}

