/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ImportTableDetailsDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ImportTableDetailsDialog.class);
    JTextField txtTableNamePattern;
    JCheckBox chkSuggestColumnTypes;
    IntegerField txtVarcharLength;
    IntegerField txtNumericPrecision;
    IntegerField txtNumericScale;
    JTextArea txtCreateTableSQL;
    JButton btnCreateTable;
    JButton btnClose;

    public ImportTableDetailsDialog(Window owningWindow) {
        super(owningWindow, s_stringMgr.getString("ImportTableDetailsDialog.table.details"), DEFAULT_MODALITY_TYPE);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
        this.getContentPane().add((Component)new MultipleLineLabel(s_stringMgr.getString("ImportTableDetailsDialog.table.name.gen.explain")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.txtTableNamePattern = new JTextField();
        this.getContentPane().add((Component)this.txtTableNamePattern, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0);
        this.chkSuggestColumnTypes = new JCheckBox(s_stringMgr.getString("ImportTableDetailsDialog.suggest.column.types.by.preview.csv.lines"));
        this.getContentPane().add((Component)this.chkSuggestColumnTypes, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.createVarcharLengthPanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.createNumericPanel(), gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 0, 5), 0, 0);
        this.txtCreateTableSQL = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.txtCreateTableSQL);
        this.getContentPane().add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints(0, 7, 1, 0, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 0), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createNumericPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ImportTableDetailsDialog.numeric.and.precision")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtNumericPrecision = new IntegerField(5, (Integer)1);
        this.txtNumericPrecision.setPreferredSize(new Dimension(200, this.txtVarcharLength.getPreferredSize().height));
        this.txtNumericPrecision.setMinimumSize(new Dimension(200, this.txtVarcharLength.getMinimumSize().height));
        this.txtNumericPrecision.setMaximumSize(new Dimension(200, this.txtVarcharLength.getMaximumSize().height));
        ret.add((Component)this.txtNumericPrecision, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ImportTableDetailsDialog.numeric.scale")), gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtNumericScale = new IntegerField(5, (Integer)1);
        this.txtNumericScale.setPreferredSize(new Dimension(200, this.txtVarcharLength.getPreferredSize().height));
        this.txtNumericScale.setMinimumSize(new Dimension(200, this.txtVarcharLength.getMinimumSize().height));
        this.txtNumericScale.setMaximumSize(new Dimension(200, this.txtVarcharLength.getMaximumSize().height));
        ret.add((Component)this.txtNumericScale, gbc);
        return ret;
    }

    private JPanel createVarcharLengthPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ImportTableDetailsDialog.varchar.length")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtVarcharLength = new IntegerField(5, (Integer)1);
        this.txtVarcharLength.setPreferredSize(new Dimension(200, this.txtVarcharLength.getPreferredSize().height));
        this.txtVarcharLength.setMinimumSize(new Dimension(200, this.txtVarcharLength.getMinimumSize().height));
        this.txtVarcharLength.setMaximumSize(new Dimension(200, this.txtVarcharLength.getMaximumSize().height));
        ret.add((Component)this.txtVarcharLength, gbc);
        return ret;
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridLayout(1, 2, 10, 10));
        this.btnCreateTable = new JButton(s_stringMgr.getString("ImportTableDetailsDialog.create.table"));
        this.btnCreateTable.setToolTipText(s_stringMgr.getString("ImportTableDetailsDialog.create.table.tooltip"));
        ret.add(this.btnCreateTable);
        this.btnClose = new JButton(s_stringMgr.getString("ImportTableDetailsDialog.close"));
        this.btnClose.setToolTipText(s_stringMgr.getString("ImportTableDetailsDialog.close.tooltip"));
        ret.add(this.btnClose);
        return ret;
    }
}

