/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.gui;

import java.awt.Window;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.CreateTableInDatabaseResult;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportTableDetailsCtrl;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.TableCreateUtils;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.TableCreatedListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableSuggestion {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableSuggestion.class);
    private String[][] _previewData;
    private boolean _headerIncluded;
    private ISession _session;
    private TableCreatedListener _tableCreatedListener;

    public TableSuggestion(ISession session, TableCreatedListener tableCreatedListener) {
        this._session = session;
        this._tableCreatedListener = tableCreatedListener;
    }

    public void showTableDialog(Window owningWindow, String tableName) {
        ImportTableDetailsCtrl importTableDetailsCtrl = new ImportTableDetailsCtrl(owningWindow, this._session, this._previewData, tableName, this._headerIncluded);
        importTableDetailsCtrl.showDialog();
        if (importTableDetailsCtrl.isCreateTable()) {
            this._execCreateTableInDatabase(importTableDetailsCtrl.getCreateSql());
        }
    }

    public void execCreateTableInDatabase(String tableName) {
        this._execCreateTableInDatabase(TableCreateUtils.suggestCreateScript(tableName, this._session, this._previewData, this._headerIncluded));
    }

    private void _execCreateTableInDatabase(String createSql) {
        CreateTableInDatabaseResult createTableInDatabaseResult = TableCreateUtils.execCreateTableInDatabase(this._session, createSql);
        if (null != createTableInDatabaseResult.getCreatedTable()) {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("TableSuggestion.created.table", createTableInDatabaseResult.getCreatedTable().getQualifiedName()));
            this._tableCreatedListener.tableCreated(createTableInDatabaseResult.getCreatedTable());
        } else if (createTableInDatabaseResult.isErrorOccured()) {
            String msg = s_stringMgr.getString("TableSuggestion.error.on.create.table.msg");
            String title = s_stringMgr.getString("TableSuggestion.error.on.create.table.title");
            EDTMessageBoxUtil.showMessageDialogOnEDT(msg, title);
        } else if (createTableInDatabaseResult.isTableNotFound()) {
            String msg = s_stringMgr.getString("TableSuggestion.created.table.not.found.msg");
            String title = s_stringMgr.getString("TableSuggestion.created.table.not.found.title");
            EDTMessageBoxUtil.showMessageDialogOnEDT(msg, title);
        } else {
            throw new IllegalStateException("Failed to interpret table creation");
        }
    }

    public void updatePreviewData(String[][] previewData, boolean headerIncluded) {
        this._previewData = previewData;
        this._headerIncluded = headerIncluded;
    }

    public void clear() {
    }
}

