/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.gui.ImportPropsDAO;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.ConfigurationPanel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.CSVSettingsBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CSVSettingsPanel
extends ConfigurationPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CSVSettingsPanel.class);
    private static ILogger s_log = LoggerController.createLogger(CSVSettingsPanel.class);
    private JRadioButton radUseChar = new JRadioButton(s_stringMgr.getString("CSVSettingsPanel.useChar"));
    private JTextField txtSeperatorChar = new JTextField(2);
    private JRadioButton radUseTab = new JRadioButton(s_stringMgr.getString("CSVSettingsPanel.useTab"));
    private JRadioButton radUseNoSeparator = new JRadioButton(s_stringMgr.getString("CSVSettingsPanel.no.separator"));
    private JComboBox cboEncoding = new JComboBox();
    private JTextField txtDateFormat = new JTextField(20);
    private JCheckBox chkUseDoubleQuotesAsTextQualifier = new JCheckBox(s_stringMgr.getString("CSVSettingsPanel.use.double.quotes.as.text.qualifier"));
    private CSVSettingsBean settings;

    public CSVSettingsPanel(CSVSettingsBean settings) {
        this.settings = settings;
        this.createUI();
        this.loadSettings();
        this.initListeners();
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.add((Component)this.radUseChar, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.add((Component)this.txtSeperatorChar, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 0, 5), 0, 0);
        this.add((Component)this.radUseTab, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 0, 5), 0, 0);
        this.add((Component)this.radUseNoSeparator, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("CSVSettingsPanel.inputFileEncoding")), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 0, 5), 0, 0);
        this.add((Component)this.cboEncoding, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("CSVSettingsPanel.dateFormat")), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)this.txtDateFormat, gbc);
        gbc = new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 10, 5), 0, 0);
        this.add((Component)this.chkUseDoubleQuotesAsTextQualifier, gbc);
    }

    private void initListeners() {
        KeyAdapter keyStateChangedListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CSVSettingsPanel.this.onStateChanged();
            }
        };
        this.radUseChar.addActionListener(e1 -> this.onStateChanged());
        this.txtSeperatorChar.addActionListener(e -> this.onStateChanged());
        this.txtSeperatorChar.addKeyListener(keyStateChangedListener);
        this.txtSeperatorChar.setToolTipText(s_stringMgr.getString("CSVSettingsPanel.seperatorCharToolTip"));
        this.radUseTab.addActionListener(e -> this.onStateChanged());
        this.radUseNoSeparator.setToolTipText(s_stringMgr.getString("CSVSettingsPanel.no.separator.tooltip"));
        this.radUseNoSeparator.addActionListener(e -> this.onStateChanged());
        this.txtDateFormat.addActionListener(e -> this.onStateChanged());
        this.txtDateFormat.addKeyListener(keyStateChangedListener);
        this.cboEncoding.addActionListener(e -> this.onStateChanged());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radUseTab);
        bg.add(this.radUseChar);
        bg.add(this.radUseNoSeparator);
    }

    @Override
    public void apply() {
        this.applySettings();
    }

    private void applySettings() {
        if (this.radUseTab.isSelected()) {
            this.settings.setSeperator(Character.valueOf('\t'));
        } else if (this.radUseNoSeparator.isSelected()) {
            this.settings.setSeperator(null);
        } else if (this.txtSeperatorChar.getText().length() > 0) {
            this.settings.setSeperator(Character.valueOf(this.txtSeperatorChar.getText().charAt(0)));
        } else {
            this.settings.setSeperator(Character.valueOf(';'));
        }
        this.settings.setImportCharset(this.cboEncoding.getSelectedItem().toString());
        this.settings.setDateFormat(this.txtDateFormat.getText());
        this.settings.setUseDoubleQuotesAsTextQualifier(this.chkUseDoubleQuotesAsTextQualifier.isSelected());
        ImportPropsDAO.setCSVSeparator(this.settings.getSeperator());
        try {
            new SimpleDateFormat(this.settings.getDateFormat());
            ImportPropsDAO.setCSVDateFormat(this.settings.getDateFormat());
        }
        catch (Exception e) {
            s_log.warn("Failed to interpret date format \"" + this.settings.getDateFormat() + "\"):", e);
            ImportPropsDAO.setCSVDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = s_stringMgr.getString("CSVSettingsPanel.warn.invalid.date.format", this.settings.getDateFormat(), Utilities.getExceptionStringSave(e), "yyyy-MM-dd HH:mm:ss");
            Main.getApplication().getMessageHandler().showWarningMessage(msg);
        }
        ImportPropsDAO.setImportCharset(this.settings.getImportCharset());
        ImportPropsDAO.setUseDoubleQuotesAsTextQualifier(this.settings.isUseDoubleQuotesAsTextQualifier());
    }

    private void loadSettings() {
        if (this.settings.getSeperator() == null) {
            this.radUseNoSeparator.setSelected(true);
        } else if (this.settings.getSeperator().charValue() == '\t') {
            this.radUseTab.setSelected(true);
        } else {
            this.radUseChar.setSelected(true);
            this.txtSeperatorChar.setText(Character.toString(this.settings.getSeperator().charValue()));
        }
        this.txtDateFormat.setText(this.settings.getDateFormat());
        for (String c : Charset.availableCharsets().keySet()) {
            this.cboEncoding.addItem(c);
        }
        this.cboEncoding.setSelectedItem(this.settings.getImportCharset());
        this.chkUseDoubleQuotesAsTextQualifier.setSelected(this.settings.isUseDoubleQuotesAsTextQualifier());
    }

    private void onStateChanged() {
        if (this.txtSeperatorChar.getText().length() > 1) {
            this.txtSeperatorChar.setText(this.txtSeperatorChar.getText().substring(0, 1));
        }
        this.txtSeperatorChar.setEnabled(this.radUseChar.isSelected());
    }
}

