/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ByteObjectMarkerUtil {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ByteObjectMarkerUtil.class);
    private static final ILogger s_log = LoggerController.createLogger(ByteObjectMarkerUtil.class);

    public static int getBomLength(File importFile, Charset charset) {
        int n;
        if (null == charset) {
            return 0;
        }
        FileInputStream bomCheckFis = new FileInputStream(importFile);
        try {
            byte[] firstFourBytes = new byte[4];
            bomCheckFis.read(firstFourBytes);
            n = ByteObjectMarkerUtil.getLengthOfBom(firstFourBytes, charset);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bomCheckFis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Utilities.wrapRuntime(e);
            }
        }
        bomCheckFis.close();
        return n;
    }

    private static int getLengthOfBom(byte[] buffer, Charset charset) {
        if (null != charset) {
            if (StandardCharsets.UTF_8.equals(charset)) {
                if ((buffer[0] & 0xFF) == 239 && (buffer[1] & 0xFF) == 187 && (buffer[2] & 0xFF) == 191) {
                    return ByteObjectMarkerUtil.logBomRemove(charset, 3);
                }
            } else if (StandardCharsets.UTF_16BE.equals(charset)) {
                if ((buffer[0] & 0xFF) == 254 && (buffer[1] & 0xFF) == 255) {
                    return ByteObjectMarkerUtil.logBomRemove(charset, 2);
                }
            } else if (StandardCharsets.UTF_16LE.equals(charset)) {
                if ((buffer[0] & 0xFF) == 255 && (buffer[1] & 0xFF) == 254) {
                    return ByteObjectMarkerUtil.logBomRemove(charset, 2);
                }
            } else if (charset.name().equals("UTF-32BE") ? (buffer[0] & 0xFF) == 0 && (buffer[1] & 0xFF) == 0 && (buffer[2] & 0xFF) == 254 && (buffer[3] & 0xFF) == 255 : charset.name().equals("UTF-32LE") && (buffer[0] & 0xFF) == 255 && (buffer[1] & 0xFF) == 254 && (buffer[2] & 0xFF) == 0 && (buffer[3] & 0xFF) == 0) {
                return ByteObjectMarkerUtil.logBomRemove(charset, 4);
            }
        }
        return 0;
    }

    private static int logBomRemove(Charset charset, int bomLength) {
        String msg = s_stringMgr.getString("ByteObjectMarkerUtil.bomRemovedMessage", charset.name(), bomLength);
        Main.getApplication().getMessageHandler().showMessage(msg);
        s_log.info(msg);
        return bomLength;
    }
}

