/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader.ByteObjectMarkerUtil;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader.ColumnBuffer;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader.CsvReaderSettings;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader.DataBuffer;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.csv.csvreader.HeadersHolder;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CsvReader {
    private static final ILogger s_log = LoggerController.createLogger(CsvReader.class);
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;
    private FileInputStream _fileInputStream;
    private InputStreamReader _inputStreamReader;
    private CsvReaderSettings _csvReaderSettings = new CsvReaderSettings();
    private Charset _charset;
    private boolean _useCustomRecordDelimiter = false;
    private DataBuffer _dataBuffer = new DataBuffer();
    private ColumnBuffer _columnBuffer = new ColumnBuffer();
    private boolean[] _isQualified;
    private HeadersHolder _headersHolder = new HeadersHolder();
    private boolean _startedColumn = false;
    private boolean _startedWithQualifier = false;
    private boolean _hasMoreData = true;
    private char _lastLetter = '\u0000';
    private boolean _hasReadNextLine = false;
    private int _columnsCount = 0;
    private long _currentRecord = 0L;
    private String[] _values = new String[10];
    private boolean _closed = false;

    public CsvReader(File importFile, String charsetName, Character delimiter, boolean trimValues, boolean useTextQualifier) {
        try {
            Charset charset = this.getCharsetByName(charsetName);
            int bomLength = ByteObjectMarkerUtil.getBomLength(importFile, charset);
            if (0 == bomLength) {
                this._fileInputStream = new FileInputStream(importFile);
                this._inputStreamReader = new InputStreamReader((InputStream)this._fileInputStream, charset);
            } else {
                this._fileInputStream = new FileInputStream(importFile);
                byte[] dumBuf = new byte[bomLength];
                this._fileInputStream.read(dumBuf);
                this._inputStreamReader = new InputStreamReader((InputStream)this._fileInputStream, charset);
            }
            this._charset = charset;
            this._csvReaderSettings.delimiter = delimiter;
            this._csvReaderSettings.trimWhitespace = trimValues;
            this._csvReaderSettings.useTextQualifier = useTextQualifier;
            this._isQualified = new boolean[this._values.length];
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private Charset getCharsetByName(String importCharset) {
        Charset charset = null;
        if (!StringUtilities.isEmpty(importCharset)) {
            try {
                charset = Charset.forName(importCharset);
            }
            catch (Exception e) {
                s_log.warn("Failed to find charset by name: " + importCharset, e);
            }
        }
        return charset;
    }

    public boolean getTrimWhitespace() {
        return this._csvReaderSettings.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this._csvReaderSettings.trimWhitespace = trimWhitespace;
    }

    public Character getDelimiter() {
        return this._csvReaderSettings.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this._csvReaderSettings.delimiter = delimiter;
    }

    public char getRecordDelimiter() {
        return this._csvReaderSettings.recordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this._useCustomRecordDelimiter = true;
        this._csvReaderSettings.recordDelimiter = recordDelimiter;
    }

    public char getTextQualifier() {
        return this._csvReaderSettings.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this._csvReaderSettings.textQualifier = textQualifier;
    }

    public boolean getUseTextQualifier() {
        return this._csvReaderSettings.useTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this._csvReaderSettings.useTextQualifier = useTextQualifier;
    }

    public char getComment() {
        return this._csvReaderSettings.comment;
    }

    public void setComment(char comment) {
        this._csvReaderSettings.comment = comment;
    }

    public boolean getUseComments() {
        return this._csvReaderSettings.useComments;
    }

    public void setUseComments(boolean useComments) {
        this._csvReaderSettings.useComments = useComments;
    }

    public int getEscapeMode() {
        return this._csvReaderSettings.escapeMode;
    }

    public void setEscapeMode(int escapeMode) throws IllegalArgumentException {
        if (escapeMode != 1 && escapeMode != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this._csvReaderSettings.escapeMode = escapeMode;
    }

    public boolean getSkipEmptyRecords() {
        return this._csvReaderSettings.skipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this._csvReaderSettings.skipEmptyRecords = skipEmptyRecords;
    }

    public boolean getSafetySwitch() {
        return this._csvReaderSettings.safetySwitch;
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this._csvReaderSettings.safetySwitch = safetySwitch;
    }

    public int getColumnCount() {
        return this._columnsCount;
    }

    public long getCurrentRecord() {
        return this._currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this._headersHolder.length;
    }

    public String[] getHeaders() throws IOException {
        this.checkClosed();
        if (this._headersHolder.headers == null) {
            return null;
        }
        String[] clone = new String[this._headersHolder.length];
        System.arraycopy(this._headersHolder.headers, 0, clone, 0, this._headersHolder.length);
        return clone;
    }

    public void setHeaders(String[] headers) {
        this._headersHolder.headers = headers;
        this._headersHolder.indexByName.clear();
        this._headersHolder.length = headers != null ? headers.length : 0;
        for (int i = 0; i < this._headersHolder.length; ++i) {
            this._headersHolder.indexByName.put(headers[i], i);
        }
    }

    public String[] getValues() throws IOException {
        this.checkClosed();
        String[] clone = new String[this._columnsCount];
        System.arraycopy(this._values, 0, clone, 0, this._columnsCount);
        return clone;
    }

    public String get(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this._columnsCount) {
            return this._values[columnIndex];
        }
        return "";
    }

    public String get(String headerName) throws IOException {
        this.checkClosed();
        return this.get(this.getIndex(headerName));
    }

    public boolean readRecord() throws IOException {
        this.checkClosed();
        this._columnsCount = 0;
        this._dataBuffer.lineStart = this._dataBuffer.position;
        this._hasReadNextLine = false;
        if (this._hasMoreData) {
            do {
                if (this._dataBuffer.position == this._dataBuffer.count) {
                    this.readInputStreamToDataBuffer();
                    continue;
                }
                this._startedWithQualifier = false;
                char currentLetter = this._dataBuffer.buffer[this._dataBuffer.position];
                if (this._csvReaderSettings.useTextQualifier && currentLetter == this._csvReaderSettings.textQualifier) {
                    this._lastLetter = currentLetter;
                    this._startedColumn = true;
                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                    this._startedWithQualifier = true;
                    boolean lastLetterWasQualifier = false;
                    char escapeChar = this._csvReaderSettings.textQualifier;
                    if (this._csvReaderSettings.escapeMode == 2) {
                        escapeChar = '\\';
                    }
                    boolean eatingTrailingJunk = false;
                    boolean lastLetterWasEscape = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    ++this._dataBuffer.position;
                    do {
                        if (this._dataBuffer.position == this._dataBuffer.count) {
                            this.readInputStreamToDataBuffer();
                            continue;
                        }
                        currentLetter = this._dataBuffer.buffer[this._dataBuffer.position];
                        if (eatingTrailingJunk) {
                            this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                            if (null != this._csvReaderSettings.delimiter && currentLetter == this._csvReaderSettings.delimiter.charValue()) {
                                this.endColumn();
                            } else if (!this._useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this._useCustomRecordDelimiter && currentLetter == this._csvReaderSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                            }
                        } else if (currentLetter == this._csvReaderSettings.textQualifier) {
                            if (lastLetterWasEscape) {
                                lastLetterWasEscape = false;
                                lastLetterWasQualifier = false;
                            } else {
                                this.updateCurrentValue();
                                if (this._csvReaderSettings.escapeMode == 1) {
                                    lastLetterWasEscape = true;
                                }
                                lastLetterWasQualifier = true;
                            }
                        } else if (this._csvReaderSettings.escapeMode == 2 && lastLetterWasEscape) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasEscape = false;
                        } else if (currentLetter == escapeChar) {
                            this.updateCurrentValue();
                            lastLetterWasEscape = true;
                        } else if (lastLetterWasQualifier) {
                            if (null != this._csvReaderSettings.delimiter && currentLetter == this._csvReaderSettings.delimiter.charValue()) {
                                this.endColumn();
                            } else if (!this._useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this._useCustomRecordDelimiter && currentLetter == this._csvReaderSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                                eatingTrailingJunk = true;
                            }
                            lastLetterWasQualifier = false;
                        }
                        this._lastLetter = currentLetter;
                        if (!this._startedColumn) continue;
                        ++this._dataBuffer.position;
                        if (!this._csvReaderSettings.safetySwitch || this._dataBuffer.position - this._dataBuffer.columnStart + this._columnBuffer.position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this._columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this._currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this._hasMoreData && this._startedColumn);
                } else if (null != this._csvReaderSettings.delimiter && currentLetter == this._csvReaderSettings.delimiter.charValue()) {
                    this._lastLetter = currentLetter;
                    this.endColumn();
                } else if (this._useCustomRecordDelimiter && currentLetter == this._csvReaderSettings.recordDelimiter) {
                    if (this._startedColumn || this._columnsCount > 0 || !this._csvReaderSettings.skipEmptyRecords) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this._dataBuffer.lineStart = this._dataBuffer.position + 1;
                    }
                    this._lastLetter = currentLetter;
                } else if (!(this._useCustomRecordDelimiter || currentLetter != '\r' && currentLetter != '\n')) {
                    if (this._startedColumn || this._columnsCount > 0 || !this._csvReaderSettings.skipEmptyRecords && (currentLetter == '\r' || this._lastLetter != '\r')) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this._dataBuffer.lineStart = this._dataBuffer.position + 1;
                    }
                    this._lastLetter = currentLetter;
                } else if (this._csvReaderSettings.useComments && this._columnsCount == 0 && currentLetter == this._csvReaderSettings.comment) {
                    this._lastLetter = currentLetter;
                    this.skipLine();
                } else if (this._csvReaderSettings.trimWhitespace && (currentLetter == ' ' || currentLetter == '\t')) {
                    this._startedColumn = true;
                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                } else {
                    this._startedColumn = true;
                    this._dataBuffer.columnStart = this._dataBuffer.position;
                    boolean lastLetterWasBackslash = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    boolean firstLoop = true;
                    do {
                        if (!firstLoop && this._dataBuffer.position == this._dataBuffer.count) {
                            this.readInputStreamToDataBuffer();
                            continue;
                        }
                        if (!firstLoop) {
                            currentLetter = this._dataBuffer.buffer[this._dataBuffer.position];
                        }
                        if (!this._csvReaderSettings.useTextQualifier && this._csvReaderSettings.escapeMode == 2 && currentLetter == '\\') {
                            if (lastLetterWasBackslash) {
                                lastLetterWasBackslash = false;
                            } else {
                                this.updateCurrentValue();
                                lastLetterWasBackslash = true;
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                            }
                        } else if (this._csvReaderSettings.escapeMode == 2 && lastLetterWasBackslash) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this._dataBuffer.columnStart = this._dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasBackslash = false;
                        } else if (null != this._csvReaderSettings.delimiter && currentLetter == this._csvReaderSettings.delimiter.charValue()) {
                            this.endColumn();
                        } else if (!this._useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this._useCustomRecordDelimiter && currentLetter == this._csvReaderSettings.recordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this._lastLetter = currentLetter;
                        firstLoop = false;
                        if (!this._startedColumn) continue;
                        ++this._dataBuffer.position;
                        if (!this._csvReaderSettings.safetySwitch || this._dataBuffer.position - this._dataBuffer.columnStart + this._columnBuffer.position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this._columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this._currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this._hasMoreData && this._startedColumn);
                }
                if (!this._hasMoreData) continue;
                ++this._dataBuffer.position;
            } while (this._hasMoreData && !this._hasReadNextLine);
            if (this._startedColumn || null != this._csvReaderSettings.delimiter && this._lastLetter == this._csvReaderSettings.delimiter.charValue()) {
                this.endColumn();
                this.endRecord();
            }
        }
        return this._hasReadNextLine;
    }

    private void readInputStreamToDataBuffer() throws IOException {
        this.updateCurrentValue();
        try {
            this._dataBuffer.count = this._inputStreamReader.read(this._dataBuffer.buffer, 0, this._dataBuffer.buffer.length);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this._dataBuffer.count == -1) {
            this._hasMoreData = false;
        }
        this._dataBuffer.position = 0;
        this._dataBuffer.lineStart = 0;
        this._dataBuffer.columnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean result = this.readRecord();
        this._headersHolder.length = this._columnsCount;
        this._headersHolder.headers = new String[this._columnsCount];
        for (int i = 0; i < this._headersHolder.length; ++i) {
            String columnValue;
            this._headersHolder.headers[i] = columnValue = this.get(i);
            this._headersHolder.indexByName.put(columnValue, i);
        }
        if (result) {
            --this._currentRecord;
        }
        this._columnsCount = 0;
        return result;
    }

    public String getHeader(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this._headersHolder.length) {
            return this._headersHolder.headers[columnIndex];
        }
        return "";
    }

    public boolean isQualified(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex < this._columnsCount && columnIndex > -1) {
            return this._isQualified[columnIndex];
        }
        return false;
    }

    private void endColumn() throws IOException {
        String currentValue = "";
        if (this._startedColumn) {
            int lastLetter;
            if (this._columnBuffer.position == 0) {
                if (this._dataBuffer.columnStart < this._dataBuffer.position) {
                    if (this._csvReaderSettings.trimWhitespace && !this._startedWithQualifier) {
                        for (lastLetter = this._dataBuffer.position - 1; lastLetter >= this._dataBuffer.columnStart && (this._dataBuffer.buffer[lastLetter] == ' ' || this._dataBuffer.buffer[lastLetter] == '\t'); --lastLetter) {
                        }
                    }
                    currentValue = new String(this._dataBuffer.buffer, this._dataBuffer.columnStart, lastLetter - this._dataBuffer.columnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this._csvReaderSettings.trimWhitespace && !this._startedWithQualifier) {
                    for (lastLetter = this._columnBuffer.position - 1; lastLetter >= 0 && (this._columnBuffer.buffer[lastLetter] == ' ' || this._columnBuffer.buffer[lastLetter] == ' '); --lastLetter) {
                    }
                }
                currentValue = new String(this._columnBuffer.buffer, 0, lastLetter + 1);
            }
        }
        this._columnBuffer.position = 0;
        this._startedColumn = false;
        if (this._columnsCount >= 100000 && this._csvReaderSettings.safetySwitch) {
            this.close();
            throw new IOException("Maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this._currentRecord) + ". Set the SafetySwitch property to false if you're expecting more than 100,000 columns per record to avoid this error.");
        }
        if (this._columnsCount == this._values.length) {
            int newLength = this._values.length * 2;
            String[] holder = new String[newLength];
            System.arraycopy(this._values, 0, holder, 0, this._values.length);
            this._values = holder;
            boolean[] qualifiedHolder = new boolean[newLength];
            System.arraycopy(this._isQualified, 0, qualifiedHolder, 0, this._isQualified.length);
            this._isQualified = qualifiedHolder;
        }
        this._values[this._columnsCount] = currentValue;
        this._isQualified[this._columnsCount] = this._startedWithQualifier;
        currentValue = "";
        ++this._columnsCount;
    }

    private void appendLetter(char letter) {
        if (this._columnBuffer.position == this._columnBuffer.buffer.length) {
            int newLength = this._columnBuffer.buffer.length * 2;
            char[] holder = new char[newLength];
            System.arraycopy(this._columnBuffer.buffer, 0, holder, 0, this._columnBuffer.position);
            this._columnBuffer.buffer = holder;
        }
        this._columnBuffer.buffer[this._columnBuffer.position++] = letter;
        this._dataBuffer.columnStart = this._dataBuffer.position + 1;
    }

    private void updateCurrentValue() {
        if (this._startedColumn && this._dataBuffer.columnStart < this._dataBuffer.position) {
            if (this._columnBuffer.buffer.length - this._columnBuffer.position < this._dataBuffer.position - this._dataBuffer.columnStart) {
                int newLength = this._columnBuffer.buffer.length + Math.max(this._dataBuffer.position - this._dataBuffer.columnStart, this._columnBuffer.buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this._columnBuffer.buffer, 0, holder, 0, this._columnBuffer.position);
                this._columnBuffer.buffer = holder;
            }
            System.arraycopy(this._dataBuffer.buffer, this._dataBuffer.columnStart, this._columnBuffer.buffer, this._columnBuffer.position, this._dataBuffer.position - this._dataBuffer.columnStart);
            this._columnBuffer.position += this._dataBuffer.position - this._dataBuffer.columnStart;
        }
        this._dataBuffer.columnStart = this._dataBuffer.position + 1;
    }

    private void endRecord() throws IOException {
        this._hasReadNextLine = true;
        ++this._currentRecord;
    }

    public int getIndex(String headerName) throws IOException {
        this.checkClosed();
        Integer indexValue = this._headersHolder.indexByName.get(headerName);
        if (indexValue != null) {
            return indexValue;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean recordRead = false;
        if (this._hasMoreData && (recordRead = this.readRecord())) {
            --this._currentRecord;
        }
        return recordRead;
    }

    public boolean skipLine() throws IOException {
        this.checkClosed();
        this._columnsCount = 0;
        boolean skippedLine = false;
        if (this._hasMoreData) {
            boolean foundEol = false;
            do {
                if (this._dataBuffer.position == this._dataBuffer.count) {
                    this.readInputStreamToDataBuffer();
                    continue;
                }
                skippedLine = true;
                char currentLetter = this._dataBuffer.buffer[this._dataBuffer.position];
                if (currentLetter == '\r' || currentLetter == '\n') {
                    foundEol = true;
                }
                this._lastLetter = currentLetter;
                if (foundEol) continue;
                ++this._dataBuffer.position;
            } while (this._hasMoreData && !foundEol);
            this._columnBuffer.position = 0;
            this._dataBuffer.lineStart = this._dataBuffer.position + 1;
        }
        return skippedLine;
    }

    public void close() {
        if (!this._closed) {
            this.close(true);
            this._closed = true;
        }
    }

    private void close(boolean closing) {
        if (!this._closed) {
            if (closing) {
                this._charset = null;
                this._headersHolder.headers = null;
                this._headersHolder.indexByName = null;
                this._dataBuffer.buffer = null;
                this._columnBuffer.buffer = null;
            }
            try {
                this._inputStreamReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._inputStreamReader = null;
            try {
                this._fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._fileInputStream = null;
            this._closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this._closed) {
            throw new IOException("This instance of the CsvReader class has already been closed.");
        }
    }

    protected void finalize() {
        this.close(false);
    }

    private static char hexToDec(char hex) {
        char result = hex >= 'a' ? (char)(hex - 97 + 10) : (hex >= 'A' ? (char)(hex - 65 + 10) : (char)(hex - 48));
        return result;
    }
}

