/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.excel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelRowReader {
    private final Sheet _sheet;
    private List<Integer> _nonNullIndexes = new ArrayList<Integer>();

    public ExcelRowReader(Sheet sheet) {
        this._sheet = sheet;
    }

    public int getNumberOfNonNullRows() {
        return this._sheet.getPhysicalNumberOfRows();
    }

    public Row getNonNullRow(int rowIndex) {
        if (rowIndex < this._nonNullIndexes.size()) {
            return this._sheet.getRow(this._nonNullIndexes.get(rowIndex).intValue());
        }
        if (this._nonNullIndexes.size() >= this.getNumberOfNonNullRows()) {
            throw new IndexOutOfBoundsException("There are only " + this._nonNullIndexes.size() + " non null rows in the sheet. So " + rowIndex + " is out of bounds.");
        }
        int nextNonNullRowSerachStartIx = 0;
        if (!this._nonNullIndexes.isEmpty()) {
            nextNonNullRowSerachStartIx = this._nonNullIndexes.get(this._nonNullIndexes.size() - 1) + 1;
        }
        int i = nextNonNullRowSerachStartIx;
        while (true) {
            Row row;
            if (null != (row = this._sheet.getRow(i))) {
                this._nonNullIndexes.add(i);
                if (rowIndex < this._nonNullIndexes.size()) {
                    return row;
                }
            }
            ++i;
        }
    }
}

