/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.excel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.ConfigurationPanel;
import net.sourceforge.squirrel_sql.client.session.action.dataimport.importer.excel.ExcelSettingsBean;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSettingsPanel
extends ConfigurationPanel {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ExcelSettingsPanel.class);
    private ExcelSettingsBean _settings;
    private Workbook _workbook;
    private JComboBox _sheetName = null;

    public ExcelSettingsPanel(ExcelSettingsBean settings, File f) {
        this._settings = settings;
        try {
            this._workbook = WorkbookFactory.create((File)f);
        }
        catch (Exception e) {
            this._workbook = null;
        }
        this.init();
        this.loadSettings();
    }

    private void init() {
        this._sheetName = new JComboBox();
        if (this._workbook != null) {
            int nSheets = this._workbook.getNumberOfSheets();
            for (int i = 0; i < nSheets; ++i) {
                this._sheetName.addItem(this._workbook.getSheetAt(i).getSheetName());
            }
        }
        this._sheetName.addActionListener(e -> this.stateChanged());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0);
        this.add((Component)GUIUtils.createHorizontalSeparatorPanel(stringMgr.getString("ExcelSettingsPanel.xlsSettings")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 30, 5), 0, 0);
        this.add((Component)new JLabel(stringMgr.getString("ExcelSettingsPanel.sheetName")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 30, 10), 0, 0);
        this.add((Component)this._sheetName, gbc);
    }

    private void applySettings() {
        if (this._sheetName.getSelectedItem() != null) {
            this._settings.setSheetName(this._sheetName.getSelectedItem().toString());
        }
    }

    private void loadSettings() {
        if (this._settings.getSheetName() == null) {
            this._sheetName.setSelectedIndex(0);
        } else {
            this._sheetName.setSelectedItem(this._settings.getSheetName());
        }
    }

    private void stateChanged() {
        this.applySettings();
    }

    @Override
    public void apply() {
    }
}

