/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff;

import java.nio.file.Path;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.DBDiffScriptFileManager;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.prefs.DBDiffPreferenceBean;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.tableselectiondiff.TableSelectionDiffUtil;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;

public class DBDiffState {
    private Path _selectedTableCellsMarkdownTempFile;
    private Path _selectedTableCellsRawSingleColumnDataTempFile;
    private ISession _sourceSession;
    private ISession _destSession;
    private IDatabaseObjectInfo[] _destSelectedDatabaseObjects;
    private IDatabaseObjectInfo[] _sourceSelectedDatabaseObjects;
    private DBDiffPreferenceBean _dbDiffPreferenceBean;
    private DBDiffScriptFileManager _scriptFileManager = new DBDiffScriptFileManager();

    public void storeSelectedTableCellsForMarkdownCompare(String selectedMarkDown) {
        this.storeSelectedTableCellsForCompare(selectedMarkDown, null);
    }

    public void storeSelectedTableCellsForCompare(String selectedMarkDown, String rawSingleColumnData) {
        this._selectedTableCellsMarkdownTempFile = TableSelectionDiffUtil.createLeftTempFile(selectedMarkDown);
        this._selectedTableCellsRawSingleColumnDataTempFile = null;
        if (null != rawSingleColumnData) {
            this._selectedTableCellsRawSingleColumnDataTempFile = TableSelectionDiffUtil.createLeftTempFile(rawSingleColumnData);
        }
    }

    public Path getSelectedTableCellsMarkdownTempFile() {
        return this._selectedTableCellsMarkdownTempFile;
    }

    public Path getSelectedTableCellsRawSingleColumnDataTempFile() {
        return this._selectedTableCellsRawSingleColumnDataTempFile;
    }

    public void setSourceSession(ISession sourceSession) {
        this._sourceSession = sourceSession;
    }

    public ISession getSourceSession() {
        return this._sourceSession;
    }

    public ISession getDestSession() {
        return this._destSession;
    }

    public void setDestSession(ISession destSession) {
        this._destSession = destSession;
    }

    public void setDestSelectedDatabaseObjects(IDatabaseObjectInfo[] destSelectedDatabaseObjects) {
        this._destSelectedDatabaseObjects = destSelectedDatabaseObjects;
    }

    public IDatabaseObjectInfo[] getDestSelectedDatabaseObjects() {
        return this._destSelectedDatabaseObjects;
    }

    public void setSourceSelectedDatabaseObjects(IDatabaseObjectInfo[] sourceSelectedDatabaseObjects) {
        this._sourceSelectedDatabaseObjects = sourceSelectedDatabaseObjects;
    }

    public IDatabaseObjectInfo[] getSourceSelectedDatabaseObjects() {
        return this._sourceSelectedDatabaseObjects;
    }

    public DBDiffPreferenceBean getDBDiffPreferenceBean() {
        if (null == this._dbDiffPreferenceBean) {
            this._dbDiffPreferenceBean = JsonMarshalUtil.readObjectFromFileSave(new ApplicationFiles().getDBDiffPrefsJsonBeanFile(), DBDiffPreferenceBean.class, new DBDiffPreferenceBean());
        }
        return this._dbDiffPreferenceBean;
    }

    public void writeDBDiffPreferenceBean(DBDiffPreferenceBean prefs) {
        this._dbDiffPreferenceBean = prefs;
        JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getDBDiffPrefsJsonBeanFile(), prefs);
    }

    public DBDiffScriptFileManager getScriptFileManager() {
        return this._scriptFileManager;
    }

    public void setScriptFileManager(DBDiffScriptFileManager scriptFileManager) {
        this._scriptFileManager = scriptFileManager;
    }
}

