/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.DBDIffService;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.tableselectiondiff.TableSelectionDiffUtil;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CompareToClipboardAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CompareToClipboardAction.class);
    private static final ILogger s_log = LoggerController.createLogger(CompareToClipboardAction.class);
    private ISQLPanelAPI _sqlPanelAPI;

    public CompareToClipboardAction() {
        super(Main.getApplication());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String clipboardAsString = ClipboardUtil.getClipboardAsString();
        if (StringUtilities.isEmpty(clipboardAsString, true)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("CompareToClipboardAction.clipboard.empty.warn"));
            return;
        }
        Path leftClipboardTempFile = TableSelectionDiffUtil.createLeftTempFile(clipboardAsString);
        String rightEditorTextToCompare = this._sqlPanelAPI.getSQLEntryPanel().getSelectedText();
        if (null == rightEditorTextToCompare && StringUtilities.isEmpty(rightEditorTextToCompare = this._sqlPanelAPI.getSQLEntryPanel().getText(), true)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("CompareToClipboardAction.editor.empty.warn"));
            return;
        }
        Path rightEditorTextTempFile = TableSelectionDiffUtil.createRightTempFile(rightEditorTextToCompare);
        String title = s_stringMgr.getString("CompareToClipboardDlg.clipboard.vs.editor");
        DBDIffService.showDiff(leftClipboardTempFile, rightEditorTextTempFile, title, this._sqlPanelAPI.getOwningFrame(), savedText -> this.onSaveText(savedText));
    }

    private void onSaveText(String textToSave) {
        if (null != textToSave) {
            if (null != this._sqlPanelAPI.getSQLEntryPanel().getSelectedText()) {
                this._sqlPanelAPI.getSQLEntryPanel().replaceSelection(textToSave);
            } else {
                this._sqlPanelAPI.setEntireSQLScript(textToSave, false);
            }
        }
    }

    @Override
    public void setSQLPanel(ISQLPanelAPI sqlPanelAPI) {
        this._sqlPanelAPI = sqlPanelAPI;
        this.setEnabled(null != this._sqlPanelAPI);
    }
}

