/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.commands.DBDiffCompareCommand;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.DiffPresentationFactoryImpl;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DBDiffCompareAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBDiffCompareAction.class);
    private static final ILogger log = LoggerController.createLogger(DBDiffCompareAction.class);

    public DBDiffCompareAction() {
        super(Main.getApplication());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ISession sourceSession = Main.getApplication().getDBDiffState().getSourceSession();
        ISession destSession = Main.getApplication().getDBDiffState().getDestSession();
        IObjectTreeAPI api = destSession.getObjectTreeAPIOfActiveSessionWindow();
        if (api == null) {
            return;
        }
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        boolean clearSource = false;
        if (this.sourceExists()) {
            Main.getApplication().getDBDiffState().setDestSelectedDatabaseObjects(dbObjs);
            clearSource = true;
        } else if (dbObjs.length == 2) {
            Main.getApplication().getDBDiffState().setSourceSession(Main.getApplication().getDBDiffState().getDestSession());
            Main.getApplication().getDBDiffState().setSourceSelectedDatabaseObjects(new IDatabaseObjectInfo[]{dbObjs[0]});
            Main.getApplication().getDBDiffState().setDestSession(Main.getApplication().getDBDiffState().getDestSession());
            Main.getApplication().getDBDiffState().setDestSelectedDatabaseObjects(new IDatabaseObjectInfo[]{dbObjs[1]});
            clearSource = true;
        } else {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("CompareAction.exactly.two.tables.when.no.source"));
        }
        if (Main.getApplication().getDBDiffState().getSourceSession() == null) {
            log.error("actionPerformed: Source session was null - A source session must be selected to perform a comparison.");
            return;
        }
        if (Main.getApplication().getDBDiffState().getDestSession() == null) {
            log.error("actionPerformed: Source session was null - A destination session must be selected to perform a comparison.");
            return;
        }
        DBDiffCompareCommand command = new DBDiffCompareCommand();
        DiffPresentationFactoryImpl diffPresentationFactory = new DiffPresentationFactoryImpl();
        command.setDiffPresentationFactory(diffPresentationFactory);
        command.execute();
        if (clearSource) {
            Main.getApplication().getDBDiffState().setSourceSelectedDatabaseObjects(new IDatabaseObjectInfo[0]);
        }
    }

    private boolean sourceExists() {
        return Main.getApplication().getDBDiffState().getSourceSession() != null && null != Main.getApplication().getDBDiffState().getSourceSelectedDatabaseObjects() && 0 < Main.getApplication().getDBDiffState().getSourceSelectedDatabaseObjects().length;
    }

    @Override
    public void setSession(ISession session) {
        Main.getApplication().getDBDiffState().setDestSession(session);
    }
}

