/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.commands;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DBDiffSelectCommand
implements ICommand {
    private final ISession _session;
    private static final ILogger log = LoggerController.createLogger(DBDiffSelectCommand.class);

    public DBDiffSelectCommand(ISession session) {
        this._session = session;
    }

    @Override
    public void execute() {
        IObjectTreeAPI api = this._session.getObjectTreeAPIOfActiveSessionWindow();
        if (api != null) {
            IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
            try {
                Main.getApplication().getDBDiffState().setSourceSession(this._session);
                Main.getApplication().getDBDiffState().setSourceSelectedDatabaseObjects(dbObjs);
            }
            catch (Exception e) {
                log.error("Unexected exception: ", e);
            }
        }
    }
}

