/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.DBDiffScriptFileManager;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.IDiffPresentation;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.prefs.DBDiffPreferenceBean;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactoryImpl;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class AbstractSideBySideDiffPresentation
implements IDiffPresentation {
    private static final ILogger s_log = LoggerController.createLogger(AbstractSideBySideDiffPresentation.class);
    protected FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();

    public abstract void executeDiff(String var1, String var2) throws Exception;

    @Override
    public void execute() {
        ISession sourceSession = Main.getApplication().getDBDiffState().getSourceSession();
        DBDiffScriptFileManager scriptFileManager = Main.getApplication().getDBDiffState().getScriptFileManager();
        IDatabaseObjectInfo[] selectedDestObjects = Main.getApplication().getDBDiffState().getDestSelectedDatabaseObjects();
        ISession destSession = Main.getApplication().getDBDiffState().getDestSession();
        IDatabaseObjectInfo[] selectedSourceObjects = Main.getApplication().getDBDiffState().getSourceSelectedDatabaseObjects();
        HibernateDialect dialect = new DialectFactoryImpl().getDialect(sourceSession.getMetaData());
        CreateScriptPreferences csprefs = new CreateScriptPreferences();
        List<ITableInfo> sourcetables = this.getContainedTableInfos(selectedSourceObjects);
        List<ITableInfo> desttables = this.getContainedTableInfos(selectedDestObjects);
        try {
            DBDiffPreferenceBean prefs = Main.getApplication().getDBDiffState().getDBDiffPreferenceBean();
            String script1 = this.constructScriptFromList(dialect.getCreateTableSQL(sourcetables, sourceSession.getMetaData(), csprefs, false, prefs.isSortColumnsForSideBySideComparison()));
            String script2 = this.constructScriptFromList(dialect.getCreateTableSQL(desttables, destSession.getMetaData(), csprefs, false, prefs.isSortColumnsForSideBySideComparison()));
            String sourceFilename = scriptFileManager.getOutputFilenameForSession(sourceSession, 1);
            String destFilename = scriptFileManager.getOutputFilenameForSession(destSession, 2);
            this.writeScriptToFile(script1, sourceFilename);
            this.writeScriptToFile(script2, destFilename);
            this.executeDiff(sourceFilename, destFilename);
        }
        catch (Exception e) {
            s_log.error("Unexpected exception while generating sql scripts : " + e.getMessage(), e);
        }
    }

    private void writeScriptToFile(String sqlscript, String file) throws IOException {
        FileWrapper sourcefileWrapper = this.fileWrapperFactory.create(file);
        new IOUtilitiesImpl().copyBytesToFile(new ByteArrayInputStream(sqlscript.getBytes()), sourcefileWrapper);
    }

    private List<ITableInfo> getContainedTableInfos(IDatabaseObjectInfo[] dbObjs) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (IDatabaseObjectInfo dbObj : dbObjs) {
            if (!(dbObj instanceof ITableInfo)) continue;
            ITableInfo ti = (ITableInfo)dbObj;
            result.add(ti);
        }
        return result;
    }

    private String constructScriptFromList(List<String> sqlscript) {
        StringBuilder script = new StringBuilder();
        for (String sql : sqlscript) {
            script.append(sql);
            script.append(";\n\n");
        }
        return script.toString();
    }
}

