/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.ColumnDifference;
import net.sourceforge.squirrel_sql.fw.gui.table.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ColumnDiffDialog
extends JDialog {
    private static StringManager s_stringMgr = StringManagerFactory.getStringManager(ColumnDiffDialog.class);
    private static final ILogger s_log = LoggerController.createLogger(ColumnDiffDialog.class);
    private JPanel columnDiffPanel;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JPanel jTabbedPane1;
    private JTable diffTable;
    private ButtonTableHeader _tableHeader;
    private JTable corner = null;
    private JPanel infoPanel;
    private JPanel diffPanel;
    private JLabel session1Label;
    private JLabel session2Label;
    private JTable _rowHeader;
    private List<ColumnDifference> _tableDiffs;
    private static final Color differenceColor = new Color(255, 166, 166);
    private static final Color missingColor = new Color(255, 230, 0);
    private final int rowHeaderColumnMinimumWidth = 120;

    public ColumnDiffDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.postInit();
        super.setLocationRelativeTo(parent);
        super.setTitle("Table/Column Differences");
    }

    public void setColumnDifferences(List<ColumnDifference> diffs) {
        if (diffs == null) {
            throw new IllegalArgumentException("diffs cannot be null");
        }
        DiffTableModel model = new DiffTableModel(diffs);
        this.diffTable.setModel(model);
        this._tableDiffs = diffs;
        RowHeaderTableModel rowheaderModel = new RowHeaderTableModel(diffs);
        this._rowHeader.setModel(rowheaderModel);
        TableColumnModel rowHeaderTableColModel = this._rowHeader.getColumnModel();
        TableColumn rowHeaderTableCol1 = rowHeaderTableColModel.getColumn(0);
        TableColumn rowHeaderTableCol2 = rowHeaderTableColModel.getColumn(1);
        TableColumnModel cornerTableColModel = this.corner.getColumnModel();
        TableColumn cornerTableCol1 = cornerTableColModel.getColumn(0);
        TableColumn cornerTableCol2 = cornerTableColModel.getColumn(1);
        int column1MinWidth = this.getLongestColumnDifferenceTableName(diffs) * 3;
        int column2MinWidth = this.getLongestColumnDifferenceColumnName(diffs) * 7;
        rowHeaderTableCol1.setMinWidth(column1MinWidth);
        rowHeaderTableCol2.setMinWidth(column2MinWidth);
        cornerTableCol1.setMinWidth(column1MinWidth);
        cornerTableCol2.setMinWidth(column2MinWidth);
        super.pack();
    }

    public void setSession1Label(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null");
        }
        this.session1Label.setText(this.getSessionLabel(1, label));
    }

    public void setSession2Label(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null");
        }
        this.session2Label.setText(this.getSessionLabel(2, label));
    }

    private int getLongestColumnDifferenceTableName(List<ColumnDifference> diffs) {
        int result = 0;
        for (ColumnDifference diff : diffs) {
            int length = diff.getTableName().length();
            if (result >= length) continue;
            result = length;
        }
        return result;
    }

    private int getLongestColumnDifferenceColumnName(List<ColumnDifference> diffs) {
        int result = 0;
        for (ColumnDifference diff : diffs) {
            int length = diff.getColumnName().length();
            if (result >= length) continue;
            result = length;
        }
        return result;
    }

    private String getSessionLabel(int sessionNum, String label) {
        StringBuilder result = new StringBuilder();
        result.append(i18n.SESSION_LABEL_PREFIX);
        result.append(sessionNum);
        result.append("  :  ");
        result.append(label);
        return result.toString();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JPanel(new GridLayout(1, 1));
        this.columnDiffPanel = new JPanel();
        this.columnDiffPanel.setBackground(Color.lightGray);
        this.jScrollPane1 = new JScrollPane();
        this.diffTable = new JTable();
        this.jPanel2 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.diffTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}}, new String[]{i18n.SESSION_LABEL_PREFIX + "1 Type", i18n.SESSION_LABEL_PREFIX + "2 Type", i18n.SESSION_LABEL_PREFIX + "1 Length", i18n.SESSION_LABEL_PREFIX + "2 Length", i18n.SESSION_LABEL_PREFIX + "1 Null", i18n.SESSION_LABEL_PREFIX + "2 Null", i18n.SESSION_LABEL_PREFIX + "1 Remarks", i18n.SESSION_LABEL_PREFIX + "2 Remarks"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.diffTable.setAutoResizeMode(0);
        this.diffTable.setDefaultRenderer(Object.class, new DiffCellRenderer());
        this.jScrollPane1.setViewportView(this.diffTable);
        GroupLayout columnDiffLayout = new GroupLayout(this.columnDiffPanel);
        this.columnDiffPanel.setLayout(columnDiffLayout);
        columnDiffLayout.setHorizontalGroup(columnDiffLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 395, Short.MAX_VALUE));
        columnDiffLayout.setVerticalGroup(columnDiffLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 264, Short.MAX_VALUE));
        this.jTabbedPane1.add(this.columnDiffPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.infoPanel = new JPanel();
        this.infoPanel.setBorder(new EmptyBorder(5, 10, 5, 0));
        this.infoPanel.setLayout(new GridLayout(2, 1));
        this.session1Label = new JLabel(i18n.SESSION_LABEL_PREFIX + "1: ");
        this.session2Label = new JLabel(i18n.SESSION_LABEL_PREFIX + "2: ");
        this.infoPanel.add(this.session1Label);
        this.infoPanel.add(this.session2Label);
        this.diffPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.diffPanel);
        this.diffPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 600, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 300, Short.MAX_VALUE).addContainerGap()));
        contentPane.add("North", this.infoPanel);
        contentPane.add("Center", this.diffPanel);
    }

    private void postInit() {
        this._rowHeader = this.getRowHeader();
        this._rowHeader.setBackground(new Color(238, 238, 238));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._rowHeader, "Center");
        this.jScrollPane1.setRowHeaderView(panel);
        this._tableHeader = new ButtonTableHeader();
        this._tableHeader.setTable(this.diffTable);
        this.diffTable.setTableHeader(this._tableHeader);
        this._tableHeader.initColWidths();
        this._tableHeader.setColumnModel(this.diffTable.getColumnModel());
        this.corner = new JTable(new CornerTableModel());
        this.corner.setRowHeight(25);
        this.corner.setBackground(Color.lightGray);
        this.corner.setAutoResizeMode(0);
        this.corner.setFont(this.corner.getFont().deriveFont(1));
        this.corner.getColumnModel().getColumn(0).setMinWidth(200);
        DefaultTableCellRenderer tcrColumn = new DefaultTableCellRenderer();
        tcrColumn.setHorizontalAlignment(0);
        this.corner.getColumnModel().getColumn(0).setCellRenderer(tcrColumn);
        this.corner.getColumnModel().getColumn(1).setCellRenderer(tcrColumn);
        JPanel cornerPanel = new JPanel();
        cornerPanel.setLayout(new BorderLayout());
        cornerPanel.add((Component)this.corner, "Center");
        this.jScrollPane1.setCorner("UPPER_LEFT_CORNER", cornerPanel);
    }

    private JTable getRowHeader() {
        RowHeaderTableModel tm = new RowHeaderTableModel();
        TableColumnModel tcm = this.getTableColumnModel(120);
        JTable result = new JTable(tm, tcm);
        result.createDefaultColumnsFromModel();
        return result;
    }

    private TableColumnModel getTableColumnModel(final int minWidth) {
        DefaultTableColumnModel result = new DefaultTableColumnModel(){

            @Override
            public void addColumn(TableColumn tc) {
                tc.setResizable(true);
                tc.setMinWidth(minWidth);
                super.addColumn(tc);
            }
        };
        return result;
    }

    private class DiffCellRenderer
    extends DefaultTableCellRenderer {
        private final Color originalCellBGColor = Color.white;

        private DiffCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component label = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ColumnDiffDialog.this._tableDiffs == null) {
                return label;
            }
            ColumnDifference diff = ColumnDiffDialog.this._tableDiffs.get(row);
            if (!diff.isCol1Exists() || !diff.isCol2Exists()) {
                this.setMissing(label, value);
                return label;
            }
            switch (column) {
                case 0: 
                case 1: {
                    if (!diff.typesEqual()) {
                        this.setHighlighted(label, value);
                        break;
                    }
                    this.setNormal(label);
                    break;
                }
                case 2: 
                case 3: {
                    if (!diff.lengthsEqual()) {
                        this.setHighlighted(label, value);
                        break;
                    }
                    this.setNormal(label);
                    break;
                }
                case 4: 
                case 5: {
                    if (!diff.nullableEqual()) {
                        this.setHighlighted(label, value);
                        break;
                    }
                    this.setNormal(label);
                    break;
                }
                case 6: 
                case 7: {
                    if (!diff.remarksEqual()) {
                        this.setHighlighted(label, value);
                        break;
                    }
                    this.setNormal(label);
                    break;
                }
                default: {
                    s_log.error("Unknown column: " + column);
                }
            }
            return label;
        }

        private void setMissing(Component label, Object value) {
            if (value != null && value.toString() != null && value.toString().equals(i18n.MISSING_LABEL)) {
                label.setBackground(missingColor);
                label.setForeground(Color.BLACK);
                label.setFont(label.getFont().deriveFont(2));
            } else {
                this.setNormal(label);
            }
        }

        private void setHighlighted(Component label, Object value) {
            label.setBackground(differenceColor);
            label.setFont(label.getFont().deriveFont(2));
            label.setForeground(Color.BLACK);
        }

        private void setNormal(Component label) {
            label.setBackground(this.originalCellBGColor);
            label.setForeground(Color.BLACK);
            label.setFont(label.getFont().deriveFont(0));
        }
    }

    private static class RowHeaderTableModel
    extends DefaultTableModel {
        private List<ColumnDifference> _diffs;

        private RowHeaderTableModel() {
        }

        public RowHeaderTableModel(List<ColumnDifference> diffs) {
            if (diffs == null) {
                throw new IllegalArgumentException("diffs cannot be null");
            }
            this._diffs = diffs;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Table";
            }
            if (column == 1) {
                return "Column";
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public int getRowCount() {
            if (this._diffs == null) {
                return 0;
            }
            return this._diffs.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ColumnDifference diff = this._diffs.get(row);
            if (column == 0) {
                return diff.getTableName();
            }
            if (column == 1) {
                return diff.getColumnName();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private static class CornerTableModel
    extends DefaultTableModel {
        private CornerTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Table";
            }
            return "Column";
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return "Table";
            }
            return "Column";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private static class DiffTableModel
    extends DefaultTableModel {
        private final List<ColumnDifference> _diffs;
        String[] columnHeadings = new String[]{i18n.SESSION_LABEL_PREFIX + "1 Type", i18n.SESSION_LABEL_PREFIX + "2 Type", i18n.SESSION_LABEL_PREFIX + "1 Length", i18n.SESSION_LABEL_PREFIX + "2 Length", i18n.SESSION_LABEL_PREFIX + "1 Null", i18n.SESSION_LABEL_PREFIX + "2 Null", i18n.SESSION_LABEL_PREFIX + "1 Remarks", i18n.SESSION_LABEL_PREFIX + "2 Remarks"};

        public DiffTableModel(List<ColumnDifference> diffs) {
            this._diffs = diffs;
        }

        @Override
        public int getColumnCount() {
            return this.columnHeadings.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnHeadings[column];
        }

        @Override
        public int getRowCount() {
            if (this._diffs == null) {
                return 0;
            }
            return this._diffs.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this._diffs == null) {
                System.err.println("_diffs is null");
                return "";
            }
            if (row >= this._diffs.size()) {
                s_log.error("specified row (" + row + ") equals or exceeds _diffs size(" + this._diffs.size() + ")");
                return "";
            }
            ColumnDifference diff = this._diffs.get(row);
            if (!diff.isCol1Exists() || !diff.isCol2Exists()) {
                if (!diff.isCol1Exists() && column % 2 == 0) {
                    return i18n.MISSING_LABEL;
                }
                if (!diff.isCol2Exists() && column % 2 == 1) {
                    return i18n.MISSING_LABEL;
                }
            }
            Object result = null;
            switch (column) {
                case 0: {
                    result = JDBCTypeMapper.getJdbcTypeName(diff.getCol1Type());
                    break;
                }
                case 1: {
                    result = JDBCTypeMapper.getJdbcTypeName(diff.getCol2Type());
                    break;
                }
                case 2: {
                    result = diff.getCol1Length();
                    break;
                }
                case 3: {
                    result = diff.getCol2Length();
                    break;
                }
                case 4: {
                    result = diff.col1AllowsNull();
                    break;
                }
                case 5: {
                    result = diff.col2AllowsNull();
                    break;
                }
                case 6: {
                    result = diff.getCol1Remarks();
                    break;
                }
                case 7: {
                    result = diff.getCol2Remarks();
                    break;
                }
                default: {
                    System.err.println("Unknown column: " + column);
                }
            }
            return result;
        }
    }

    static interface i18n {
        public static final String SESSION_LABEL_PREFIX = s_stringMgr.getString("ColumnDiffDialog.sessionLabelPrefix");
        public static final String MISSING_LABEL = s_stringMgr.getString("ColumnDiffDialog.missingLabel");
    }
}

