/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui;

import com.jidesoft.swing.JideTabbedPane;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.jmeld.JMeldConfigCtrl;
import net.sourceforge.squirrel_sql.client.gui.jmeld.JMeldUtil;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.JMeldPanelHandlerSaveCallback;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.ConfigurableMeldPanel;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.JMeldDiffPresentation;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.NonExitingJMeldPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.JMeldPanel;

public class JMeldCore {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(JMeldDiffPresentation.class);
    private boolean _useEmbedded;
    private JMeldPanel _meldPanel;
    private ConfigurableMeldPanel _configurableMeldPanel;

    public JMeldCore() {
        this(false);
    }

    public JMeldCore(boolean useEmbedded) {
        this._useEmbedded = useEmbedded;
        if (!this._useEmbedded) {
            return;
        }
        this._configurableMeldPanel = this.createPanel(null);
    }

    public void executeDiff(String leftFilename, String rightFilename, String diffDialogTitle) {
        this.executeDiff(leftFilename, rightFilename, diffDialogTitle, null);
    }

    public void executeDiff(String leftFilename, String rightFilename, String diffDialogTitle, JMeldPanelHandlerSaveCallback saveCallback) {
        this.executeDiff(leftFilename, rightFilename, diffDialogTitle, saveCallback, Main.getApplication().getMainFrame());
    }

    public void executeDiff(String leftFilename, String rightFilename, String diffDialogTitle, JMeldPanelHandlerSaveCallback saveCallback, Window owningWindow) {
        if (this._useEmbedded) {
            this.cleanMeldPanel();
            this.doCompare(leftFilename, rightFilename, saveCallback);
        } else {
            JDialog diffDialog = new JDialog(owningWindow, diffDialogTitle);
            this._configurableMeldPanel = this.createPanel(diffDialog);
            diffDialog.getContentPane().setLayout(new GridLayout(1, 1));
            diffDialog.add(this._configurableMeldPanel);
            JMeldSettings.getInstance().setDrawCurves(true);
            GUIUtils.enableCloseByEscape(diffDialog, w -> this.cleanMeldPanel());
            diffDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JMeldCore.this.cleanMeldPanel();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    JMeldCore.this.cleanMeldPanel();
                }
            });
            GUIUtils.initLocation(diffDialog, 500, 400, JMeldDiffPresentation.class.getName());
            this.doCompare(leftFilename, rightFilename, saveCallback);
            diffDialog.setVisible(true);
        }
    }

    private void doCompare(String leftFilename, String rightFilename, JMeldPanelHandlerSaveCallback saveCallback) {
        EditorSettings editorSettings = JMeldSettings.getInstance().getEditor();
        JMeldSettings.getInstance().getEditor().enableCustomFont(true);
        JMeldSettings.getInstance().getEditor().setFont(new Font("Monospaced", 0, new JLabel().getFont().getSize()));
        editorSettings.setRightsideReadonly(null == saveCallback);
        editorSettings.setLeftsideReadonly(true);
        if (null != saveCallback) {
            GUIUtils.forceProperty(() -> 1 < JMeldPanel.getContentPanelList((JideTabbedPane)this._meldPanel.getTabbedPane()).size(), () -> this.prepareSaveButton(this._meldPanel, saveCallback));
        }
        this._meldPanel.openComparison(leftFilename, rightFilename);
    }

    private void prepareSaveButton(JMeldPanel meldPanel, JMeldPanelHandlerSaveCallback saveCallback) {
        JButton saveButton = this.getRightFilePanel(meldPanel).getSaveButton();
        saveButton.addActionListener(e -> this.onSaveToEditor(meldPanel, saveCallback));
        saveButton.setToolTipText(s_stringMgr.getString("JMeldCore.write.changes.to.sql.editor"));
    }

    private FilePanel getRightFilePanel(JMeldPanel meldPanel) {
        for (AbstractContentPanel abstractContentPanel : JMeldPanel.getContentPanelList((JideTabbedPane)meldPanel.getTabbedPane())) {
            if (!(abstractContentPanel instanceof BufferDiffPanel)) continue;
            return ((BufferDiffPanel)abstractContentPanel).getFilePanel(2);
        }
        throw new IllegalStateException("Failed to return org.jmeld.ui.FilePanel");
    }

    private void onSaveToEditor(JMeldPanel meldPanel, JMeldPanelHandlerSaveCallback saveCallback) {
        String savedText = this.getRightFilePanel(meldPanel).getEditor().getText();
        saveCallback.rightSideSaved(savedText);
    }

    private ConfigurableMeldPanel createPanel(JDialog diffDialog) {
        this._meldPanel = new NonExitingJMeldPanel(() -> this.close(diffDialog));
        this._meldPanel.SHOW_TABBEDPANE_OPTION.disable();
        this._meldPanel.SHOW_TOOLBAR_OPTION.disable();
        this._meldPanel.SHOW_FILE_LABEL_OPTION.disable();
        return new ConfigurableMeldPanel(this._meldPanel, new JMeldConfigCtrl(this._meldPanel));
    }

    public ConfigurableMeldPanel getConfigurableMeldPanel() {
        return this._configurableMeldPanel;
    }

    private void close(JDialog diffDialog) {
        this.cleanMeldPanel();
        if (null != diffDialog) {
            diffDialog.setVisible(false);
            diffDialog.dispose();
        }
    }

    public void cleanMeldPanel() {
        JMeldUtil.cleanMeldPanel(this._meldPanel);
    }
}

