/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.ColumnDifference;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.TableDiffExecutor;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.ColumnDiffDialog;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.gui.IDiffPresentation;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TabularDiffPresentation
implements IDiffPresentation {
    private static final ILogger s_log = LoggerController.createLogger(TabularDiffPresentation.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TabularDiffPresentation.class);
    private final List<ColumnDifference> colDifferences = new ArrayList<ColumnDifference>();

    @Override
    public void execute() {
        this._execute();
    }

    private void _execute() {
        IDatabaseObjectInfo[] destObjs;
        IDatabaseObjectInfo[] sourceObjs = Main.getApplication().getDBDiffState().getSourceSelectedDatabaseObjects();
        if (!this.sanityCheck(sourceObjs, destObjs = Main.getApplication().getDBDiffState().getDestSelectedDatabaseObjects())) {
            return;
        }
        ISQLDatabaseMetaData sourceMetaData = Main.getApplication().getDBDiffState().getSourceSession().getMetaData();
        ISQLDatabaseMetaData destMetaData = Main.getApplication().getDBDiffState().getDestSession().getMetaData();
        TableDiffExecutor diff = new TableDiffExecutor(sourceMetaData, destMetaData);
        if (sourceObjs.length == 1 && destObjs.length == 1) {
            diff.setTableInfos((ITableInfo)sourceObjs[0], (ITableInfo)destObjs[0]);
            diff.execute();
            this.colDifferences.addAll(diff.getColumnDifferences());
        } else {
            List<ITableInfo> tableList1 = this.getTableList(sourceMetaData, sourceObjs);
            List<ITableInfo> tableList2 = this.getTableList(destMetaData, destObjs);
            for (int i = 0; i < tableList1.size(); ++i) {
                ITableInfo t1 = tableList1.get(i);
                ITableInfo t2 = tableList2.get(i);
                diff.setTableInfos(t1, t2);
                diff.execute();
                List<ColumnDifference> columnDiffs = diff.getColumnDifferences();
                if (columnDiffs == null || columnDiffs.size() <= 0) continue;
                this.colDifferences.addAll(columnDiffs);
                for (ColumnDifference colDiff : columnDiffs) {
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug(colDiff.toString());
                }
            }
        }
        if (this.colDifferences != null && this.colDifferences.size() > 0) {
            ColumnDiffDialog dialog = new ColumnDiffDialog((Frame)Main.getApplication().getMainFrame(), false);
            dialog.setColumnDifferences(this.colDifferences);
            dialog.setSession1Label(Main.getApplication().getDBDiffState().getSourceSession().getAlias().getName());
            dialog.setSession2Label(Main.getApplication().getDBDiffState().getDestSession().getAlias().getName());
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(Main.getApplication().getMainFrame(), i18n.NO_DIFFS_MESSAGE, "DBDiff", 1);
        }
    }

    private List<ITableInfo> getTableList(ISQLDatabaseMetaData md, IDatabaseObjectInfo[] objs) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        if (objs[0].getDatabaseObjectType() == DatabaseObjectType.TABLE) {
            for (IDatabaseObjectInfo info : objs) {
                if (!(info instanceof ITableInfo)) continue;
                result.add((ITableInfo)info);
            }
        }
        return result;
    }

    private boolean sanityCheck(IDatabaseObjectInfo[] sourceObjs, IDatabaseObjectInfo[] destObjs) {
        boolean result = true;
        if (sourceObjs.length != destObjs.length) {
            JOptionPane.showMessageDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("TabularDiffPresentation.number.of.dest.and.source.objects.mismatch"));
            result = false;
        }
        if (sourceObjs[0].getDatabaseObjectType() != destObjs[0].getDatabaseObjectType()) {
            JOptionPane.showMessageDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("TabularDiffPresentation.objects.type.mismatch"));
            result = false;
        }
        return result;
    }

    static interface i18n {
        public static final String NO_DIFFS_MESSAGE = s_stringMgr.getString("TabularDiffPresentation.noDiffsMessage");
    }
}

