/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.dbdiff.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.prefs.DBDiffPreferenceBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DBDiffPreferencesPanel
extends JPanel
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBDiffPreferencesPanel.class);
    JRadioButton tabularPresentationRadioButton = null;
    JRadioButton sideBySidePresentationRadioButton = null;
    JRadioButton internalDiffWindowRadioButton = null;
    JRadioButton externalDiffToolRadionButton = null;
    JLabel externalDiffToolCommandLabel = null;
    JTextField externalDiffToolCommandTextField = null;
    JCheckBox sortColumnsCheckBox = null;

    @Override
    public void initialize(IApplication app) {
        this.createGUI();
        this.loadData();
    }

    @Override
    public void uninitialize(IApplication app) {
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0);
        this.add((Component)new MultipleLineLabel(s_stringMgr.getString("DBDiffPreferencesPanel.configure.table.diff.presentation")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.createTopPanel(), gbc);
    }

    private JPanel createTopPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        ret.setBorder(BorderFactory.createEtchedBorder());
        this.tabularPresentationRadioButton = new JRadioButton(s_stringMgr.getString("DBDiffPreferencesPanel.tabularPresentationRadioButtonLabel"));
        this.addSideBySidePresentationRadioButton(ret, 0, 0);
        ButtonGroup tabularsidebyside = new ButtonGroup();
        tabularsidebyside.add(this.tabularPresentationRadioButton);
        tabularsidebyside.add(this.sideBySidePresentationRadioButton);
        this.addInternalDiffWindowRadioButton(ret, 0, 1);
        this.addExternalDiffToolRadioButton(ret, 0, 2);
        ButtonGroup internalExternalButtonGroup = new ButtonGroup();
        internalExternalButtonGroup.add(this.internalDiffWindowRadioButton);
        internalExternalButtonGroup.add(this.externalDiffToolRadionButton);
        this.addExternalDiffToolCommandLabel(ret, 0, 3);
        this.addExternalDiffToolCommandTextField(ret, 1, 3);
        this.addSortColumnsCheckBoxLabel(ret, 0, 4);
        this.addTabularPresentationRadioButton(ret, 0, 5);
        return ret;
    }

    private void addSortColumnsCheckBoxLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        this.sortColumnsCheckBox = new JCheckBox(s_stringMgr.getString("DBDiffPreferencesPanel.sortColumnsForSideBySideComparisonLabel"));
        this.sortColumnsCheckBox.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.sortColumnsForSideBySideComparisonToolTip"));
        panel.add((Component)this.sortColumnsCheckBox, c);
    }

    private void addTabularPresentationRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 5, 0);
        c.anchor = 17;
        this.tabularPresentationRadioButton.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.tabularPresentationRadioButtonToolTipText"));
        this.tabularPresentationRadioButton.addActionListener(e -> this.updateEnableState());
        panel.add((Component)this.tabularPresentationRadioButton, c);
    }

    private void addSideBySidePresentationRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.anchor = 17;
        this.sideBySidePresentationRadioButton = new JRadioButton(s_stringMgr.getString("DBDiffPreferencesPanel.sideBySidePresentationRadionButtonLabel"));
        this.sideBySidePresentationRadioButton.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.sideBySidePresentationRadionButtonToolTip"));
        this.sideBySidePresentationRadioButton.addActionListener(e -> this.updateEnableState());
        panel.add((Component)this.sideBySidePresentationRadioButton, c);
    }

    private void addExternalDiffToolRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        this.externalDiffToolRadionButton = new JRadioButton(s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolRadionButtonLabel"));
        this.externalDiffToolRadionButton.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolRadionButtonToolTip"));
        this.externalDiffToolRadionButton.addActionListener(e -> this.updateEnableState());
        panel.add((Component)this.externalDiffToolRadionButton, c);
    }

    private void addInternalDiffWindowRadioButton(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 20, 0, 0);
        c.anchor = 17;
        this.internalDiffWindowRadioButton = new JRadioButton(s_stringMgr.getString("DBDiffPreferencesPanel.internalDiffWindowRadionButtonLabel"));
        this.internalDiffWindowRadioButton.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.internalDiffWindowRadionButtonToolTip"));
        this.internalDiffWindowRadioButton.addActionListener(e -> this.updateEnableState());
        panel.add((Component)this.internalDiffWindowRadioButton, c);
    }

    private void addExternalDiffToolCommandLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 45, 0, 0);
        this.externalDiffToolCommandLabel = new JLabel(s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandLabel"));
        this.externalDiffToolCommandLabel.setHorizontalAlignment(4);
        this.externalDiffToolCommandLabel.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandToolTip"));
        panel.add((Component)this.externalDiffToolCommandLabel, c);
    }

    private void addExternalDiffToolCommandTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.externalDiffToolCommandTextField = new JTextField(10);
        this.externalDiffToolCommandTextField.setHorizontalAlignment(2);
        this.externalDiffToolCommandTextField.setToolTipText(s_stringMgr.getString("DBDiffPreferencesPanel.externalDiffToolCommandToolTip"));
        panel.add((Component)this.externalDiffToolCommandTextField, c);
    }

    private void loadData() {
        DBDiffPreferenceBean prefs = Main.getApplication().getDBDiffState().getDBDiffPreferenceBean();
        this.tabularPresentationRadioButton.setSelected(prefs.isUseTabularDiffPresentation());
        this.sideBySidePresentationRadioButton.setSelected(!prefs.isUseTabularDiffPresentation());
        this.externalDiffToolRadionButton.setSelected(prefs.isUseExternalGraphicalDiffTool());
        this.internalDiffWindowRadioButton.setSelected(!prefs.isUseExternalGraphicalDiffTool());
        this.sortColumnsCheckBox.setSelected(prefs.isSortColumnsForSideBySideComparison());
        this.externalDiffToolCommandTextField.setText(prefs.getGraphicalToolCommand());
        this.updateEnableState();
    }

    private void updateEnableState() {
        if (this.tabularPresentationRadioButton.isSelected()) {
            this.internalDiffWindowRadioButton.setEnabled(false);
            this.externalDiffToolRadionButton.setEnabled(false);
            this.externalDiffToolCommandLabel.setEnabled(false);
            this.externalDiffToolCommandTextField.setEnabled(false);
            this.sortColumnsCheckBox.setEnabled(false);
        }
        if (this.sideBySidePresentationRadioButton.isSelected()) {
            this.internalDiffWindowRadioButton.setEnabled(true);
            this.externalDiffToolRadionButton.setEnabled(true);
            this.sortColumnsCheckBox.setEnabled(true);
            this.externalDiffToolCommandLabel.setEnabled(this.externalDiffToolRadionButton.isSelected());
            this.externalDiffToolCommandTextField.setEnabled(this.externalDiffToolRadionButton.isSelected());
        }
    }

    @Override
    public void applyChanges() {
        DBDiffPreferenceBean prefs = new DBDiffPreferenceBean();
        prefs.setUseTabularDiffPresentation(this.tabularPresentationRadioButton.isSelected());
        prefs.setUseExternalGraphicalDiffTool(this.externalDiffToolRadionButton.isSelected());
        prefs.setGraphicalToolCommand(this.externalDiffToolCommandTextField.getText());
        prefs.setSortColumnsForSideBySideComparison(this.sortColumnsCheckBox.isSelected());
        File dbDiffPrefsJsonBeanFile = new ApplicationFiles().getDBDiffPrefsJsonBeanFile();
        JsonMarshalUtil.writeObjectToFile(dbDiffPrefsJsonBeanFile, prefs);
        Main.getApplication().getDBDiffState().writeDBDiffPreferenceBean(prefs);
    }

    @Override
    public Component getPanelComponent() {
        return this;
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("DBDiffPreferencesPanel.hint");
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("DBDiffPreferencesPanel.title");
    }
}

