/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.file;

import java.awt.event.ActionEvent;
import java.util.Optional;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;

public class FileSaveAllAction
extends SquirrelAction
implements ISessionAction {
    private ISession _session;

    public FileSaveAllAction() {
        super(Main.getApplication());
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ISQLPanelAPI activeSqlPanelApi = null;
        int caretPosition = 0;
        if (null != Main.getApplication().getSessionManager().getActiveSession() && null != (activeSqlPanelApi = Main.getApplication().getSessionManager().getActiveSession().getSQLPanelAPIOfActiveSessionWindow(true))) {
            caretPosition = activeSqlPanelApi.getCaretPosition();
        }
        for (ISession session : Main.getApplication().getSessionManager().getOpenSessions()) {
            for (SQLPanel sqlPanel : session.getSessionPanel().getAllSQLPanels()) {
                FileHandler fileHandler = sqlPanel.getSQLPanelAPI().getFileHandler();
                if (null == fileHandler.getFile()) continue;
                fileHandler.fileSave();
            }
            for (ISessionWidget sessionWidget : Main.getApplication().getWindowManager().getAllFramesOfSession(session.getIdentifier())) {
                FileHandler fileHandler;
                if (!(sessionWidget instanceof SQLInternalFrame) || null == (fileHandler = ((SQLInternalFrame)sessionWidget).getMainSQLPanelAPI().getFileHandler()).getFile()) continue;
                fileHandler.fileSave();
            }
        }
        if (null != activeSqlPanelApi) {
            this.reactivateSqlPanel(activeSqlPanelApi, caretPosition);
        }
    }

    private void reactivateSqlPanel(ISQLPanelAPI activeSqlPanelApi, int caretPosition) {
        block0 : switch (activeSqlPanelApi.getSQLPanelPosition()) {
            case MAIN_TAB_IN_SESSION_WINDOW: {
                SessionUtils.activateMainSqlTab(activeSqlPanelApi.getSession().getSessionInternalFrame(), caretPosition, true);
                break;
            }
            case ADDITIONAL_TAB_IN_SESSION_WINDOW: {
                ISQLPanelAPI finalActiveSqlPanelApi = activeSqlPanelApi;
                Optional<AdditionalSQLTab> additionalSQLTab = this._session.getSessionPanel().getAdditionalSQLTabs().stream().filter(t -> t.getSQLPanelAPI() == finalActiveSqlPanelApi).findFirst();
                if (!additionalSQLTab.isPresent()) break;
                SessionUtils.activateAdditionalSqlTab(this._session.getSessionInternalFrame(), additionalSQLTab.get(), caretPosition, true);
                break;
            }
            case IN_SQL_WORKSHEET: {
                for (IWidget widget : Main.getApplication().getMainFrame().getDesktopContainer().getAllWidgets()) {
                    if (!(widget instanceof SQLInternalFrame) || ((SQLInternalFrame)widget).getSQLPanel().getSQLPanelAPI() != activeSqlPanelApi) continue;
                    SessionUtils.activateSqlInternalFrame((SQLInternalFrame)widget, caretPosition, true);
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SQLPanelPosition: " + activeSqlPanelApi.getSQLPanelPosition());
            }
        }
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
        this.setEnabled(null != this._session);
    }
}

