/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.findcolums;

import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ColumnSearchCriterion {
    private boolean _findInObjectName;
    private boolean _findInColumnName;
    private boolean _findInColumnTypeName;
    private boolean _findInRemarks;
    private FilterMatcher _fullMatcher;
    private FilterMatcher _columnMatcher;
    private FilterMatcher _tableMatcher;

    public void setFilterString(String filterString) {
        this._fullMatcher = null;
        this._columnMatcher = null;
        this._tableMatcher = null;
        if (StringUtilities.isEmpty(filterString, true)) {
            return;
        }
        this._fullMatcher = new FilterMatcher(this.prepareSearchString(filterString), null);
        String[] splits = filterString.split("\\.");
        if (1 < splits.length) {
            this._columnMatcher = new FilterMatcher(this.prepareSearchString(splits[splits.length - 1]), null);
            this._tableMatcher = new FilterMatcher(this.prepareSearchString(splits[splits.length - 2]), null);
        }
    }

    private String prepareSearchString(String filterString) {
        if (!filterString.contains("%") && !filterString.contains("_")) {
            return "%" + filterString.toLowerCase().trim() + "%";
        }
        return filterString.toLowerCase().trim();
    }

    public void setFindInObjectName(boolean findInObjectName) {
        this._findInObjectName = findInObjectName;
    }

    public void setFindInColumnName(boolean findInColumnName) {
        this._findInColumnName = findInColumnName;
    }

    public void setFindInColumnTypeName(boolean findInColumnTypeName) {
        this._findInColumnTypeName = findInColumnTypeName;
    }

    public void setFindInRemarks(boolean findInRemarks) {
        this._findInRemarks = findInRemarks;
    }

    public boolean matches(ExtendedColumnInfo columnInfo) {
        if (null == this._fullMatcher) {
            return true;
        }
        if (this._findInColumnTypeName && null != columnInfo.getColumnType() && this._fullMatcher.matches(columnInfo.getColumnType().toLowerCase())) {
            return true;
        }
        if (this._findInRemarks && null != columnInfo.getRemarks() && this._fullMatcher.matches(columnInfo.getRemarks().toLowerCase())) {
            return true;
        }
        if (this._findInObjectName && null != columnInfo.getSimpleTableName() && this._fullMatcher.matches(columnInfo.getSimpleTableName().toLowerCase())) {
            return true;
        }
        if (this._findInColumnName && null != columnInfo.getColumnName() && this._fullMatcher.matches(columnInfo.getColumnName().toLowerCase())) {
            return true;
        }
        return this._findInObjectName && this._findInColumnName && null != this._columnMatcher && null != this._tableMatcher && null != columnInfo.getColumnName() && null != columnInfo.getSimpleTableName() && this._columnMatcher.matches(columnInfo.getColumnName().toLowerCase()) && this._tableMatcher.matches(columnInfo.getSimpleTableName().toLowerCase());
    }
}

