/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.findcolums;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.ColumnSearchCriterion;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsDlg;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsResultBean;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsResultTableDefinition;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsScope;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.SearchResultReader;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.JavabeanArrayDataSet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class FindColumnsCtrl {
    private static final String PREF_KEY_FILTER_STRING = "FindColumnsCtrl.filter.string";
    private static final String PREF_KEY_FIND_IN_OBJECT_NAME = "FindColumnsCtrl.find.in.objectName";
    private static final String PREF_KEY_FIND_IN_COLUMN_NAME = "FindColumnsCtrl.find.in.columnName";
    private static final String PREF_KEY_FIND_IN_COLUMN_TYPE_NAME = "FindColumnsCtrl.find.in.columnTypeName";
    private static final String PREF_KEY_FIND_IN_REMARKS = "FindColumnsCtrl.find.in.remarks";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindColumnsCtrl.class);
    private final FindColumnsDlg _dlg;
    private final JavabeanArrayDataSet _resultDataSet;
    private FindColumnsScope _findColumnsScope;
    private SearchResultReader _searchResultReader;

    public FindColumnsCtrl(FindColumnsScope findColumnsScope) {
        try {
            this._findColumnsScope = findColumnsScope;
            this._findColumnsScope.getSession().addSimpleSessionListener(() -> this.onClose());
            this._dlg = new FindColumnsDlg(findColumnsScope.getOwningWindow(), findColumnsScope.getDialogTitle());
            this._searchResultReader = new SearchResultReader(this._dlg, (res, numberOfTablesDone, totalNumberOfTables) -> this.displayResult(res, numberOfTablesDone, totalNumberOfTables));
            this._resultDataSet = new JavabeanArrayDataSet(FindColumnsResultBean.class);
            for (FindColumnsResultTableDefinition def : FindColumnsResultTableDefinition.values()) {
                this._resultDataSet.setColHeader(def.getBeanPropName(), def.getColHeader());
                this._resultDataSet.setColPos(def.getBeanPropName(), def.ordinal());
            }
            this._dlg.tblSearchResult.getTable().setSelectionMode(0);
            this._dlg.tblSearchResult.getTable().getSelectionModel().setSelectionInterval(0, 0);
            this._resultDataSet.setJavaBeanList(new ArrayList());
            this._dlg.tblSearchResult.show(this._resultDataSet);
            this._dlg.tblSearchResult.getTable().getButtonTableHeader().adjustAllColWidths(true);
            GUIUtils.enableCloseByEscape(this._dlg, dialog -> this.onClose());
            this._dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FindColumnsCtrl.this.onWindowClosing();
                }
            });
            GUIUtils.initLocation(this._dlg, 800, 500);
            this._dlg.txtFilter.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    FindColumnsCtrl.this.onKeyPressed(e);
                }
            });
            this._dlg.btnFind.addActionListener(e -> this.onFind());
            this._dlg.btnStopSearching.addActionListener(e -> this._searchResultReader.stopSearching());
            this._dlg.btnClose.addActionListener(e -> this.onClose());
            this.applyPrefs();
            this._dlg.setVisible(true);
            GUIUtils.forceFocus(this._dlg.txtFilter);
        }
        catch (DataSetException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void onWindowClosing() {
        this.storePrefs();
        this._searchResultReader.stopSearching();
    }

    private void onClose() {
        this.storePrefs();
        this._searchResultReader.stopSearching();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void applyPrefs() {
        this._dlg.txtFilter.setText(Props.getString(PREF_KEY_FILTER_STRING, null));
        this._dlg.txtFilter.selectAll();
        this._dlg.chkColumnName.setSelected(Props.getBoolean(PREF_KEY_FIND_IN_COLUMN_NAME, true));
        this._dlg.chkObjectName.setSelected(Props.getBoolean(PREF_KEY_FIND_IN_OBJECT_NAME, false));
        this._dlg.chkColumnTypeName.setSelected(Props.getBoolean(PREF_KEY_FIND_IN_COLUMN_TYPE_NAME, false));
        this._dlg.chkRemarks.setSelected(Props.getBoolean(PREF_KEY_FIND_IN_REMARKS, false));
    }

    private void storePrefs() {
        if (StringUtilities.isEmpty(this._dlg.txtFilter.getText(), true)) {
            Props.putString(PREF_KEY_FILTER_STRING, null);
        } else {
            Props.putString(PREF_KEY_FILTER_STRING, this._dlg.txtFilter.getText().trim());
        }
        Props.putBoolean(PREF_KEY_FIND_IN_OBJECT_NAME, this._dlg.chkObjectName.isSelected());
        Props.putBoolean(PREF_KEY_FIND_IN_COLUMN_NAME, this._dlg.chkColumnName.isSelected());
        Props.putBoolean(PREF_KEY_FIND_IN_COLUMN_TYPE_NAME, this._dlg.chkColumnTypeName.isSelected());
        Props.putBoolean(PREF_KEY_FIND_IN_REMARKS, this._dlg.chkRemarks.isSelected());
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this._dlg.btnFind.doClick();
        }
    }

    private void onFind() {
        ColumnSearchCriterion searchCriterion = new ColumnSearchCriterion();
        if (StringUtilities.isEmpty(this._dlg.txtFilter.getText(), true)) {
            if (0 != JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("FindColumnsCtrl.msg.list.all.tables"))) {
                return;
            }
        } else {
            searchCriterion.setFilterString(this._dlg.txtFilter.getText());
        }
        searchCriterion.setFindInObjectName(this._dlg.chkObjectName.isSelected());
        searchCriterion.setFindInColumnName(this._dlg.chkColumnName.isSelected());
        searchCriterion.setFindInColumnTypeName(this._dlg.chkColumnTypeName.isSelected());
        searchCriterion.setFindInRemarks(this._dlg.chkRemarks.isSelected());
        this._searchResultReader.findAndShowResults(searchCriterion, this._findColumnsScope.getITableInfos(), this._findColumnsScope.getSession().getSchemaInfo());
    }

    private void displayResult(ArrayList<FindColumnsResultBean> searchResults, int numberOfTablesDone, int totalNumberOfTables) {
        try {
            this._resultDataSet.setJavaBeanList(searchResults);
            this._dlg.tblSearchResult.show(this._resultDataSet);
            this._dlg.tblSearchResult.getTable().getButtonTableHeader().adjustAllColWidths(true);
            this._dlg.txtStatus.setText(s_stringMgr.getString("FindColumnsCtrl.result.count", this._resultDataSet.getSize(), numberOfTablesDone, totalNumberOfTables));
        }
        catch (DataSetException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

