/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.findcolums;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FindColumnsScope {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindColumnsScope.class);
    private IObjectTreeAPI _objectTreeAPI;
    private ISession _session;
    private Window _owningWindow;
    private List<ITableInfo> _tableInfos;
    private String _findDialogTitle;

    public FindColumnsScope(List<ITableInfo> tablesInfos, ISession session, Window owningWindow, String findDialogTitle) {
        this._owningWindow = owningWindow;
        this._tableInfos = tablesInfos;
        this._session = session;
        this._findDialogTitle = findDialogTitle;
    }

    public FindColumnsScope(ISession session) {
        this._session = session;
        this._owningWindow = GUIUtils.getOwningWindow(this._session.getSessionPanel());
        this._findDialogTitle = s_stringMgr.getString("FindColumnsScope.dialog.title.unspecified");
    }

    public FindColumnsScope(IObjectTreeAPI objectTreeAPI) {
        this._objectTreeAPI = objectTreeAPI;
        this._session = objectTreeAPI.getSession();
        this._owningWindow = GUIUtils.getOwningWindow(this._objectTreeAPI.getObjectTree());
        this._findDialogTitle = this.createDialogTitle();
    }

    private String createDialogTitle() {
        String ret;
        List<ITableInfo> selectedTables = this._objectTreeAPI.getSelectedTables();
        if (0 < selectedTables.size()) {
            ret = s_stringMgr.getString("FindColumnsScope.dialog.title.selected.tables");
        } else {
            ObjectTreeNode[] selectedNodes = this._objectTreeAPI.getSelectedNodes();
            HashSet<String> typeNames = new HashSet<String>();
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (ObjectTreeNode selectedNode : selectedNodes) {
                if (selectedNode.getDatabaseObjectType() != DatabaseObjectType.SCHEMA && selectedNode.getDatabaseObjectType() != DatabaseObjectType.CATALOG) continue;
                typeNames.add(selectedNode.getDatabaseObjectType().getName());
                nodeNames.add(selectedNode.getDatabaseObjectInfo().getSimpleName());
            }
            ret = 1 == typeNames.size() ? (1 == nodeNames.size() ? s_stringMgr.getString("FindColumnsScope.dialog.title.selected.catalogOrSchema", typeNames.iterator().next(), nodeNames.iterator().next()) : s_stringMgr.getString("FindColumnsScope.dialog.title.selected.catalogsOrSchemas", typeNames.iterator().next())) : (1 == selectedNodes.length ? s_stringMgr.getString("FindColumnsScope.dialog.title.selected.node", selectedNodes[0].getDatabaseObjectInfo().getSimpleName()) : s_stringMgr.getString("FindColumnsScope.dialog.title.selected.nodes"));
        }
        return ret;
    }

    public ISession getSession() {
        return this._session;
    }

    public Window getOwningWindow() {
        return this._owningWindow;
    }

    public String getDialogTitle() {
        return this._findDialogTitle;
    }

    public ITableInfo[] getITableInfos() {
        if (null != this._tableInfos) {
            return this._tableInfos.toArray(new ITableInfo[0]);
        }
        if (null == this._objectTreeAPI || this.containsDatabaseNode(this._objectTreeAPI.getSelectedNodes())) {
            return this._session.getSchemaInfo().getITableInfos();
        }
        ArrayList<ITableInfo> ret = new ArrayList<ITableInfo>();
        for (ObjectTreeNode selectedNode : this._objectTreeAPI.getSelectedNodes()) {
            String catalog;
            if (DatabaseObjectType.TABLE.equals(selectedNode.getDatabaseObjectType()) || DatabaseObjectType.VIEW.equals(selectedNode.getDatabaseObjectType())) {
                this.addUnique(ret, (ITableInfo)selectedNode.getDatabaseObjectInfo());
                continue;
            }
            if (DatabaseObjectType.SCHEMA.equals(selectedNode.getDatabaseObjectType())) {
                String schema = selectedNode.getDatabaseObjectInfo().getSimpleName();
                String catalog2 = null;
                ObjectTreeNode parent = (ObjectTreeNode)selectedNode.getParent();
                if (DatabaseObjectType.CATALOG.equals(parent.getDatabaseObjectType())) {
                    catalog2 = parent.getDatabaseObjectInfo().getSimpleName();
                }
                this.addAllUnique(ret, this._session.getSchemaInfo().getITableInfos(catalog2, schema));
                continue;
            }
            if (DatabaseObjectType.CATALOG.equals(selectedNode.getDatabaseObjectType())) {
                catalog = selectedNode.getDatabaseObjectInfo().getSimpleName();
                this.addAllUnique(ret, this._session.getSchemaInfo().getITableInfos(catalog, null));
                continue;
            }
            if (!DatabaseObjectType.TABLE_TYPE_DBO.equals(selectedNode.getDatabaseObjectType())) continue;
            if (0 == selectedNode.getChildCount()) {
                this._objectTreeAPI.expandNode(selectedNode);
            }
            for (int i = 0; i < selectedNode.getChildCount(); ++i) {
                IDatabaseObjectInfo child = ((ObjectTreeNode)selectedNode.getChildAt(i)).getDatabaseObjectInfo();
                if (!(child instanceof ITableInfo)) continue;
                this.addUnique(ret, (ITableInfo)child);
            }
            catalog = selectedNode.getDatabaseObjectInfo().getSimpleName();
            this.addAllUnique(ret, this._session.getSchemaInfo().getITableInfos(catalog, null));
        }
        return ret.toArray(new ITableInfo[0]);
    }

    private void addAllUnique(ArrayList<ITableInfo> toFill, ITableInfo[] tableInfos) {
        for (ITableInfo tableInfo : tableInfos) {
            this.addUnique(toFill, tableInfo);
        }
    }

    private void addUnique(ArrayList<ITableInfo> toFill, ITableInfo databaseObjectInfo) {
        toFill.remove(databaseObjectInfo);
        toFill.add(databaseObjectInfo);
    }

    private boolean containsDatabaseNode(ObjectTreeNode[] selectedNodes) {
        return Arrays.stream(selectedNodes).anyMatch(selectedNode -> DatabaseObjectType.SESSION.equals(selectedNode.getDatabaseObjectType()));
    }
}

