/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.findcolums;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.ColumnSearchCriterion;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.DislplayResultsCallback;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsCtrl;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsDlg;
import net.sourceforge.squirrel_sql.client.session.action.findcolums.FindColumnsResultBean;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class SearchResultReader {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FindColumnsCtrl.class);
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private Object sync = new Object();
    private volatile boolean _doStopSearching = false;
    private FindColumnsDlg _dlg;
    private DislplayResultsCallback _dislplayResultsCallback;
    private Future<?> _currentFuture;

    public SearchResultReader(FindColumnsDlg dlg, DislplayResultsCallback dislplayResultsCallback) {
        this._dlg = dlg;
        this._dislplayResultsCallback = dislplayResultsCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSearching() {
        Object object = this.sync;
        synchronized (object) {
            if (this._dlg.isSearching()) {
                this._doStopSearching = true;
            }
        }
    }

    void findAndShowResults(ColumnSearchCriterion searchCriterion, ITableInfo[] tableInfos, SchemaInfo schemaInfo) {
        ArrayList searchResults = new ArrayList();
        try {
            this._doStopSearching = true;
            if (null != this._currentFuture) {
                this._currentFuture.get();
            }
            this._doStopSearching = false;
            SwingUtilities.invokeLater(() -> this._findAndShowResults(0, searchCriterion, schemaInfo, searchResults, tableInfos));
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _findAndShowResults(int beginIndex, ColumnSearchCriterion searchCriterion, SchemaInfo schemaInfo, ArrayList<FindColumnsResultBean> searchResults, ITableInfo[] tableInfos) {
        try {
            long beginMillis = System.currentTimeMillis();
            for (int i = beginIndex; i < tableInfos.length; ++i) {
                ExtendedColumnInfo[] columnInfos;
                if (0 < i && System.currentTimeMillis() - beginMillis > 500L) {
                    int numberOfTablesDone = i + 1;
                    GUIUtils.processOnSwingEventThread(() -> this._dislplayResultsCallback.displayResult(searchResults, numberOfTablesDone, tableInfos.length));
                    if (0 == beginIndex) {
                        GUIUtils.processOnSwingEventThread(() -> this._dlg.setSearching(true));
                        int finalBeginIndex = i;
                        this._currentFuture = this._executorService.submit(() -> this._findAndShowResults(finalBeginIndex, searchCriterion, schemaInfo, searchResults, tableInfos));
                        return;
                    }
                    beginMillis = System.currentTimeMillis();
                }
                ITableInfo tableInfo = tableInfos[i];
                for (ExtendedColumnInfo columnInfo : columnInfos = schemaInfo.getExtendedColumnInfos(tableInfo.getCatalogName(), tableInfo.getSchemaName(), tableInfo.getSimpleName())) {
                    if (this._doStopSearching) {
                        Object object = this.sync;
                        synchronized (object) {
                            GUIUtils.processOnSwingEventThread(() -> this.cancelReadResultLoop());
                            return;
                        }
                    }
                    if (!searchCriterion.matches(columnInfo)) continue;
                    searchResults.add(this.createResultBean(tableInfo, columnInfo));
                }
            }
            GUIUtils.processOnSwingEventThread(() -> this.finishReadResultLoop(searchResults, tableInfos.length));
        }
        catch (Throwable e) {
            GUIUtils.processOnSwingEventThread(() -> {
                throw Utilities.wrapRuntime(e);
            });
            throw Utilities.wrapRuntime(e);
        }
    }

    private void cancelReadResultLoop() {
        this._dlg.setSearching(false);
        this._dlg.txtStatus.setText(this._dlg.txtStatus.getText() + "  (" + s_stringMgr.getString("SearchResultReader.stopped") + ")");
    }

    private void finishReadResultLoop(ArrayList<FindColumnsResultBean> searchResults, int totalNumberOfTables) {
        this._dislplayResultsCallback.displayResult(searchResults, totalNumberOfTables, totalNumberOfTables);
        this._dlg.setSearching(false);
    }

    private FindColumnsResultBean createResultBean(ITableInfo tableInfo, ExtendedColumnInfo columnInfo) {
        FindColumnsResultBean bean = new FindColumnsResultBean();
        bean.setCatalogName(tableInfo.getCatalogName());
        bean.setSchemaName(tableInfo.getSchemaName());
        bean.setObjectName(tableInfo.getSimpleName());
        bean.setObjectTypeName(tableInfo.getType());
        bean.setColumnName(columnInfo.getColumnName());
        bean.setColumnTypeName(columnInfo.getColumnType());
        bean.setNullable(columnInfo.isNullable() ? 1 : 0);
        bean.setSize(columnInfo.getColumnSize());
        bean.setPrecision(columnInfo.getTableColumnInfo().getRadix());
        bean.setDecimalDigits(columnInfo.getDecimalDigits());
        bean.setOrdinalPosition(columnInfo.getTableColumnInfo().getOrdinalPosition());
        bean.setRemarks(columnInfo.getRemarks());
        bean.setJavaSqlType(columnInfo.getColumnTypeID());
        return bean;
    }
}

