/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.io.File;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelection;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelectionStore;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelectionStoreItem;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeSelectionStoreManager {
    private static final ILogger s_log = LoggerController.createLogger(ObjectTreeSelectionStoreManager.class);
    private ObjectTreeSelectionStore _objectTreeSelectionStore;

    public void save() {
        if (null != this._objectTreeSelectionStore) {
            JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getObjectTreeSelectionStoreJsonFile(), this._objectTreeSelectionStore);
        }
    }

    public void store(ObjectTreeSelection objectTreeSelection, String name) {
        this.init();
        for (ObjectTreeSelectionStoreItem objectTreeSelectionStoreItem : this._objectTreeSelectionStore.getObjectTreeSelectionStoreItems()) {
            if (!name.equals(objectTreeSelectionStoreItem.getName())) continue;
            this._objectTreeSelectionStore.getObjectTreeSelectionStoreItems().remove(objectTreeSelectionStoreItem);
            break;
        }
        ObjectTreeSelectionStoreItem buf = new ObjectTreeSelectionStoreItem();
        buf.setName(name);
        buf.setObjectTreeSelection(objectTreeSelection);
        this._objectTreeSelectionStore.getObjectTreeSelectionStoreItems().add(0, buf);
    }

    private void init() {
        if (null != this._objectTreeSelectionStore) {
            return;
        }
        this._objectTreeSelectionStore = new ObjectTreeSelectionStore();
        try {
            File objectTreeSelectionStoreJsonFile = new ApplicationFiles().getObjectTreeSelectionStoreJsonFile();
            if (objectTreeSelectionStoreJsonFile.exists()) {
                this._objectTreeSelectionStore = JsonMarshalUtil.readObjectFromFile(objectTreeSelectionStoreJsonFile, ObjectTreeSelectionStore.class);
            }
        }
        catch (Exception e) {
            s_log.error("Failed to read file " + new ApplicationFiles().getObjectTreeSelectionStoreJsonFile(), e);
        }
    }

    public List<ObjectTreeSelectionStoreItem> getItems() {
        this.init();
        return this._objectTreeSelectionStore.getObjectTreeSelectionStoreItems();
    }
}

