/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreePathSelection;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelection;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeSelectionUtil {
    private static final ILogger s_log = LoggerController.createLogger(ObjectTreeSelectionUtil.class);

    public static String selectionToJsonString(IObjectTreeAPI tree) {
        ObjectTreeSelection objectTreeSelection = ObjectTreeSelectionUtil.selectionToObjectTreeSelection(tree);
        return JsonMarshalUtil.toJsonString(objectTreeSelection);
    }

    public static ObjectTreeSelection selectionToObjectTreeSelection(IObjectTreeAPI tree) {
        ObjectTreeSelection objectTreeSelection = new ObjectTreeSelection();
        for (ObjectTreeNode selectedNode : tree.getSelectedNodes()) {
            ObjectTreePathSelection objectTreePathSelection = new ObjectTreePathSelection();
            objectTreeSelection.getObjectTreePathSelections().add(objectTreePathSelection);
            for (TreeNode pathNodeObj : selectedNode.getPath()) {
                if (!(pathNodeObj instanceof ObjectTreeNode)) {
                    s_log.error("ObjectTreeNode \"" + pathNodeObj + "\" is not an instance of ObjectTreeNode but of " + (null == pathNodeObj ? "<null>" : pathNodeObj.getClass().getName()));
                    continue;
                }
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)pathNodeObj;
                IDatabaseObjectInfo databaseObjectInfo = objectTreeNode.getDatabaseObjectInfo();
                objectTreePathSelection.getSimpleNamePath().add(databaseObjectInfo.getSimpleName());
            }
            objectTreePathSelection.setTypeName(selectedNode.getDatabaseObjectType().getName());
        }
        Collections.sort(objectTreeSelection.getObjectTreePathSelections(), (ps1, ps2) -> ObjectTreeSelectionUtil.compareSelections(ps1, ps2));
        return objectTreeSelection;
    }

    private static int compareSelections(ObjectTreePathSelection ps1, ObjectTreePathSelection ps2) {
        for (int i = 0; i < Math.min(ps1.getSimpleNamePath().size(), ps2.getSimpleNamePath().size()); ++i) {
            int res = ps1.getSimpleNamePath().get(i).compareTo(ps2.getSimpleNamePath().get(i));
            if (res == 0) continue;
            return res;
        }
        return Integer.compare(ps1.getSimpleNamePath().size(), ps2.getSimpleNamePath().size());
    }

    public static void applySelection(IObjectTreeAPI tree, String objectTreeSelectionJsonString) {
        ObjectTreeSelection objectTreeSelection = JsonMarshalUtil.fromJsonString(objectTreeSelectionJsonString, ObjectTreeSelection.class);
        ObjectTreeSelectionUtil.applySelection(tree, objectTreeSelection);
    }

    public static void applySelection(IObjectTreeAPI tree, ObjectTreeSelection objectTreeSelection) {
        ObjectTreeNode[] selectedNodes = tree.getSelectedNodes();
        if (0 == selectedNodes.length) {
            selectedNodes = new ObjectTreeNode[]{tree.getRootNode()};
        }
        tree.getObjectTree().clearSelection();
        for (ObjectTreeNode selNode : selectedNodes) {
            TreeNode parent = selNode.getParent();
            if (null != parent && ObjectTreeSelectionUtil.applySelectionToSiblings(selNode.getDatabaseObjectInfo().getDatabaseObjectType())) {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    TreeNode child = parent.getChildAt(i);
                    if (!(child instanceof ObjectTreeNode)) {
                        s_log.error("ObjectTreeNode \"" + child + "\" is not an instance of ObjectTreeNode but of " + (null == child ? "<null>" : child.getClass().getName()));
                        continue;
                    }
                    ObjectTreeSelectionUtil.applyObjectTreeSelectionFromThisNodeOn(tree, (ObjectTreeNode)child, objectTreeSelection);
                }
            }
            ObjectTreeSelectionUtil.applyObjectTreeSelectionFromThisNodeOn(tree, selNode, objectTreeSelection);
        }
    }

    private static void applyObjectTreeSelectionFromThisNodeOn(IObjectTreeAPI tree, ObjectTreeNode node, ObjectTreeSelection objectTreeSelection) {
        HashMap<String, ObjectTreePathSelection> selectedNames_objectTreePathSelection = new HashMap<String, ObjectTreePathSelection>();
        for (ObjectTreePathSelection objectTreePathSelection : objectTreeSelection.getObjectTreePathSelections()) {
            List<String> simpleNamePath = objectTreePathSelection.getSimpleNamePath();
            if (simpleNamePath.isEmpty()) continue;
            selectedNames_objectTreePathSelection.put(simpleNamePath.get(simpleNamePath.size() - 1).toLowerCase(), objectTreePathSelection);
        }
        ObjectTreeSelectionUtil.applySelections(tree, node, selectedNames_objectTreePathSelection);
    }

    private static void applySelections(IObjectTreeAPI tree, ObjectTreeNode curNode, HashMap<String, ObjectTreePathSelection> selectedNames_objectTreePathSelection) {
        if (ObjectTreeSelectionUtil.isNodeInSelection(curNode, selectedNames_objectTreePathSelection)) {
            if (curNode.getParent() instanceof ObjectTreeNode) {
                tree.getObjectTree().expandPath(new TreePath(((ObjectTreeNode)curNode.getParent()).getPath()));
            }
            tree.getObjectTree().addSelectionPath(new TreePath(curNode.getPath()));
        }
        tree.getObjectTree().expandNode(curNode);
        for (int i = 0; i < curNode.getChildCount(); ++i) {
            TreeNode child = curNode.getChildAt(i);
            if (!(child instanceof ObjectTreeNode)) {
                s_log.error("ObjectTreeNode \"" + child + "\" is not an instance of ObjectTreeNode but of " + (null == child ? "<null>" : child.getClass().getName()));
                continue;
            }
            ObjectTreeSelectionUtil.applySelections(tree, (ObjectTreeNode)child, selectedNames_objectTreePathSelection);
        }
    }

    private static boolean isNodeInSelection(ObjectTreeNode curNode, HashMap<String, ObjectTreePathSelection> selectedNames_objectTreePathSelection) {
        IDatabaseObjectInfo databaseObjectInfo = curNode.getDatabaseObjectInfo();
        return selectedNames_objectTreePathSelection.containsKey(databaseObjectInfo.getSimpleName().toLowerCase()) && databaseObjectInfo.getDatabaseObjectType().getName().equals(selectedNames_objectTreePathSelection.get(databaseObjectInfo.getSimpleName().toLowerCase()).getTypeName());
    }

    private static boolean applySelectionToSiblings(DatabaseObjectType databaseObjectType) {
        return false == (DatabaseObjectType.SESSION.equals(databaseObjectType) || DatabaseObjectType.CATALOG.equals(databaseObjectType) || DatabaseObjectType.SCHEMA.equals(databaseObjectType) || databaseObjectType.isContainerNode());
    }

    public static String generateSelectionName(ObjectTreeSelection objectTreeSelection) {
        Object name = String.join((CharSequence)"/", objectTreeSelection.getObjectTreePathSelections().get(0).getSimpleNamePath());
        if (1 < objectTreeSelection.getObjectTreePathSelections().size()) {
            name = (String)name + " ...";
        }
        return name;
    }
}

