/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SaveObjectTreeSelectionAsDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SaveObjectTreeSelectionAsDlg.class);
    private JTextField _txtSelectionName = new JTextField();
    private JButton _btnOk;
    private JButton _btnCancel;
    private boolean _ok;

    public SaveObjectTreeSelectionAsDlg(Window parentFrame, String generatedName) {
        super(parentFrame, s_stringMgr.getString("SaveObjectTreeSelectionAsDlg.title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.layoutUI(generatedName);
        this._btnOk.addActionListener(e -> this.onOk());
        this._btnCancel.addActionListener(e -> this.close());
        this.getRootPane().setDefaultButton(this._btnOk);
        GUIUtils.enableCloseByEscape(this);
        GUIUtils.initLocation(this, 450, 140);
        GUIUtils.forceFocus(this._txtSelectionName);
        this.setVisible(true);
    }

    private void onOk() {
        if (StringUtilities.isEmpty(this._txtSelectionName.getText(), true)) {
            JOptionPane.showConfirmDialog(this, s_stringMgr.getString("SaveObjectTreeSelectionAsDlg.empty.name"));
            return;
        }
        this._ok = true;
        this.close();
    }

    public boolean isOk() {
        return this._ok;
    }

    public String getObjectTreeSelectionName() {
        return this._txtSelectionName.getText().trim();
    }

    public void setOk(boolean ok) {
        this._ok = ok;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void layoutUI(String generatedName) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.getContentPane().add((Component)new JLabel(s_stringMgr.getString("SaveObjectTreeSelectionAsDlg.label")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 0, 10), 0, 0);
        this._txtSelectionName.setText(generatedName);
        this._txtSelectionName.selectAll();
        this.getContentPane().add((Component)this._txtSelectionName, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 10, 10, 10), 0, 0);
        this.getContentPane().add((Component)this.createOkCancelPanel(), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.getContentPane().add((Component)new JPanel(), gbc);
    }

    private JPanel createOkCancelPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._btnOk = new JButton(s_stringMgr.getString("SaveObjectTreeSelectionAsDlg.ok"));
        ret.add((Component)this._btnOk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this._btnCancel = new JButton(s_stringMgr.getString("SaveObjectTreeSelectionAsDlg.cancel"));
        ret.add((Component)this._btnCancel, gbc);
        return ret;
    }
}

