/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelection;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelectionUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class StoreObjectTreeSelectionAction
extends SquirrelAction
implements IObjectTreeAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StoreObjectTreeSelectionAction.class);
    private IObjectTreeAPI _tree;

    public StoreObjectTreeSelectionAction() {
        super(Main.getApplication());
    }

    @Override
    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this.setEnabled(null != this._tree);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ObjectTreeSelection objectTreeSelection = ObjectTreeSelectionUtil.selectionToObjectTreeSelection(this._tree);
        if (objectTreeSelection.getObjectTreePathSelections().isEmpty()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("StoreObjectTreeSelectionAction.cannot.store.empty.selection"));
            return;
        }
        String name = ObjectTreeSelectionUtil.generateSelectionName(objectTreeSelection);
        Main.getApplication().getObjectTreeSelectionStoreManager().store(objectTreeSelection, name);
    }
}

