/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.awt.Window;
import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelection;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelectionUtil;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.SaveObjectTreeSelectionAsDlg;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class StoreObjectTreeSelectionNamedAction
extends SquirrelAction
implements IObjectTreeAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StoreObjectTreeSelectionNamedAction.class);
    private IObjectTreeAPI _tree;

    public StoreObjectTreeSelectionNamedAction() {
        super(Main.getApplication());
    }

    @Override
    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this.setEnabled(null != this._tree);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ObjectTreeSelection objectTreeSelection = ObjectTreeSelectionUtil.selectionToObjectTreeSelection(this._tree);
        if (objectTreeSelection.getObjectTreePathSelections().isEmpty()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("StoreObjectTreeSelectionNamedAction.cannot.store.empty.selection"));
            return;
        }
        String generatedName = ObjectTreeSelectionUtil.generateSelectionName(objectTreeSelection);
        SaveObjectTreeSelectionAsDlg dlg = new SaveObjectTreeSelectionAsDlg((Window)GUIUtils.getOwningFrame(this._tree.getObjectTree()), generatedName);
        if (dlg.isOk()) {
            Main.getApplication().getObjectTreeSelectionStoreManager().store(objectTreeSelection, dlg.getObjectTreeSelectionName());
        }
    }
}

