/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection;

import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelection;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.ObjectTreeSelectionStoreItemWrapper;
import net.sourceforge.squirrel_sql.client.session.action.objecttreecopyrestoreselection.StoredObjectTreeSelectionDlg;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class StoredObjectTreeSelectionCtrl {
    private final StoredObjectTreeSelectionDlg _dlg;
    private boolean _ok;

    public StoredObjectTreeSelectionCtrl(Window owningWindow) {
        this._dlg = new StoredObjectTreeSelectionDlg(owningWindow);
        List<ObjectTreeSelectionStoreItemWrapper> wrappedItems = ObjectTreeSelectionStoreItemWrapper.wrap(Main.getApplication().getObjectTreeSelectionStoreManager().getItems());
        DefaultListModel<ObjectTreeSelectionStoreItemWrapper> model = new DefaultListModel<ObjectTreeSelectionStoreItemWrapper>();
        model.addAll(wrappedItems);
        this._dlg.lstObjectTreeSelections.setModel(model);
        this._dlg.lstObjectTreeSelections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StoredObjectTreeSelectionCtrl.this.onListClicked(e);
            }
        });
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.btnCancel.addActionListener(e -> this.close());
        this._dlg.btnDeleteSelected.addActionListener(e -> this.onDeleteSelected());
        GUIUtils.initLocation(this._dlg, 500, 500);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onDeleteSelected() {
        DefaultListModel model = (DefaultListModel)this._dlg.lstObjectTreeSelections.getModel();
        for (int selectedIndex : this._dlg.lstObjectTreeSelections.getSelectedIndices()) {
            ObjectTreeSelectionStoreItemWrapper wrapper = (ObjectTreeSelectionStoreItemWrapper)model.getElementAt(selectedIndex);
            Main.getApplication().getObjectTreeSelectionStoreManager().getItems().remove(wrapper.getItem());
            model.remove(selectedIndex);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount() && null != this._dlg.lstObjectTreeSelections.getSelectedValue()) {
            this.onOk();
        }
    }

    private void onOk() {
        this._ok = true;
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    public ObjectTreeSelection getObjectTreeSelection() {
        if (!this._ok || null == this._dlg.lstObjectTreeSelections.getSelectedValue()) {
            return null;
        }
        return this._dlg.lstObjectTreeSelections.getSelectedValue().getObjectTreeSelection();
    }
}

