/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.reconnect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectController;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ReconnectDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ReconnectController.class);
    JButton btnYes;
    JButton btnNo;
    JButton btnCancel = new JButton(s_stringMgr.getString("ReconnectAction.cancel"));
    JButton btnToggleCollapsed;
    JTextField txtUrl = new JTextField();
    JTextField txtUser = new JTextField();
    JPasswordField txtPassword = new JPasswordField();
    JCheckBox chkSkipReconnect = new JCheckBox(s_stringMgr.getString("ReconnectAction.skip.opening.new.connection"));
    private JPanel _pnlCollapseableHolder = new JPanel(new GridLayout(1, 1));
    private JPanel _collapsedPanel;
    private JPanel _uncollapsedPanel;
    private ImageIcon _iconPlus = Main.getApplication().getResources().getIcon("plus");
    private ImageIcon _iconMinus = Main.getApplication().getResources().getIcon("minus");

    public ReconnectDialog() {
        super(Main.getApplication().getMainFrame(), s_stringMgr.getString("ReconnectAction.reconnect.title"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 5, 5, 5), 0, 0);
        JLabel lblTitle = new JLabel(s_stringMgr.getString("ReconnectAction.confirmReconnect"));
        this.getContentPane().add((Component)lblTitle, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createCollapsablePanel(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createDoNotReconnectPanel(), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
        this.getRootPane().setDefaultButton(this.btnYes);
    }

    private JPanel createDoNotReconnectPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        String infoMsg = s_stringMgr.getString("ReconnectAction.skip.opening.new.connection.info");
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkSkipReconnect.setToolTipText(infoMsg);
        ret.add((Component)this.chkSkipReconnect, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new SmallToolTipInfoButton(infoMsg).getButton(), gbc);
        return ret;
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new BorderLayout(5, 5));
        this.btnYes = new JButton(s_stringMgr.getString("ReconnectAction.yes"));
        this.btnYes.setMnemonic(s_stringMgr.getString("ReconnectAction.yes.mnemonic").charAt(0));
        ret.add((Component)this.btnYes, "West");
        this.btnNo = new JButton(s_stringMgr.getString("ReconnectAction.no"));
        this.btnNo.setMnemonic(s_stringMgr.getString("ReconnectAction.no.mnemonic").charAt(0));
        ret.add((Component)this.btnNo, "Center");
        ret.add((Component)this.btnCancel, "East");
        return ret;
    }

    private JPanel createCollapsablePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this._collapsedPanel = new JPanel();
        this._collapsedPanel.setBorder(BorderFactory.createEtchedBorder());
        this._collapsedPanel.setPreferredSize(new Dimension(this._collapsedPanel.getPreferredSize().width, 4));
        this._uncollapsedPanel = this.createUncollapsedPanel();
        this.btnToggleCollapsed = new JButton(this._iconPlus);
        GUIUtils.styleAsToolbarButton(this.btnToggleCollapsed);
        int top = this.btnToggleCollapsed.getPreferredSize().height / 2 - 1;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(top, 0, 0, 0), 0, 0);
        ret.add((Component)this._pnlCollapseableHolder, gbc);
        this.collapse();
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.btnToggleCollapsed, gbc);
        this.btnToggleCollapsed.addActionListener(e -> this.onToggleCollapsed());
        return ret;
    }

    private JPanel createUncollapsedPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new MultipleLineLabel(s_stringMgr.getString("ReconnectAction.connect.data.change.use")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ReconnectAction.url")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.txtUrl, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ReconnectAction.user")), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.txtUser, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ReconnectAction.password")), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.txtPassword, gbc);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private void onToggleCollapsed() {
        if (this._iconMinus == this.btnToggleCollapsed.getIcon()) {
            this.collapse();
        } else if (this._iconPlus == this.btnToggleCollapsed.getIcon()) {
            this.uncollapse();
        }
    }

    void uncollapse() {
        this._pnlCollapseableHolder.removeAll();
        this._pnlCollapseableHolder.add(this._uncollapsedPanel);
        this.setSize(new Dimension(500, 330));
        this.btnToggleCollapsed.setIcon(this._iconMinus);
    }

    void collapse() {
        this._pnlCollapseableHolder.removeAll();
        this._pnlCollapseableHolder.add(this._collapsedPanel);
        this._pnlCollapseableHolder.invalidate();
        this.setSize(new Dimension(500, 180));
        this.btnToggleCollapsed.setIcon(this._iconPlus);
    }

    public boolean isCollapsed() {
        return this.btnToggleCollapsed.getIcon() == this._iconPlus;
    }
}

