/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.OpenInSessionPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OpenInSessionDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OpenInSessionDlg.class);
    private OpenInSessionPanel _openInSessionPanel;
    private JButton _btnOk;
    private JButton _btnCancel;
    private boolean _isOk;

    public OpenInSessionDlg(JFrame owner, String savedSessionName, boolean warnDiscardExistingSqlEditors) {
        super(owner, s_stringMgr.getString("OpenInSessionDlg.title"), true);
        this.layoutUI(savedSessionName, warnDiscardExistingSqlEditors);
        this._btnOk.addActionListener(e -> this.onOk());
        this._btnCancel.addActionListener(e -> this.close());
        GUIUtils.initLocation(this, 450, 180);
        GUIUtils.enableCloseByEscape(this);
        this.setVisible(true);
    }

    private void onOk() {
        this._isOk = true;
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void layoutUI(String savedSessionName, boolean warnDiscardExistingSqlEditors) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this._openInSessionPanel = new OpenInSessionPanel(savedSessionName, warnDiscardExistingSqlEditors);
        this.getContentPane().add((Component)this._openInSessionPanel, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        this._btnOk = new JButton(s_stringMgr.getString("OpenInSessionDlg.Ok"));
        ret.add((Component)this._btnOk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0);
        this._btnCancel = new JButton(s_stringMgr.getString("OpenInSessionDlg.Cancel"));
        ret.add((Component)this._btnCancel, gbc);
        GUIUtils.setJButtonSizesTheSame(this._btnOk, this._btnCancel);
        this.getRootPane().setDefaultButton(this._btnOk);
        return ret;
    }

    public boolean isOk() {
        return this._isOk;
    }

    public boolean isOpenInNewSession() {
        return this._openInSessionPanel.isOpenInNewSession();
    }
}

