/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class OpenInSessionPanel
extends JPanel {
    private static final String PREF_OPEN_IN_NEW_SESSION = "SavedSession.OpenInSessionDlg.openInNewSession";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OpenInSessionPanel.class);
    private JRadioButton _radOpenInNewSession;
    private JRadioButton _radOpenInCurrentSession;
    private JLabel _lblDecide;
    private MultipleLineLabel _multiLblDecide;

    public OpenInSessionPanel(String savedSessionName, boolean warnDiscardExistingSqlEditors) {
        this.setLayout(new GridBagLayout());
        this.layoutUI(savedSessionName, warnDiscardExistingSqlEditors);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._radOpenInNewSession);
        bg.add(this._radOpenInCurrentSession);
        this._radOpenInNewSession.setSelected(Props.getBoolean(PREF_OPEN_IN_NEW_SESSION, true));
        this._radOpenInCurrentSession.setSelected(!Props.getBoolean(PREF_OPEN_IN_NEW_SESSION, true));
        this._radOpenInNewSession.addActionListener(e -> this.savePref());
        this._radOpenInCurrentSession.addActionListener(e -> this.savePref());
    }

    private void savePref() {
        Props.putBoolean(PREF_OPEN_IN_NEW_SESSION, this._radOpenInNewSession.isSelected());
    }

    private void layoutUI(String savedSessionName, boolean warnDiscardExistingSqlEditors) {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        if (StringUtilities.isEmpty(savedSessionName, true)) {
            this._lblDecide = new JLabel(s_stringMgr.getString("OpenInSessionPanel.decide.label.exc.name"));
            this.add((Component)this._lblDecide, gbc);
        } else {
            this._multiLblDecide = new MultipleLineLabel(s_stringMgr.getString("OpenInSessionPanel.decide.label.inc.name", savedSessionName));
            this.add((Component)this._multiLblDecide, gbc);
        }
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        this._radOpenInNewSession = new JRadioButton(s_stringMgr.getString("OpenInSessionPanel.open.in.new.session"));
        this.add((Component)this._radOpenInNewSession, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 5, 0, 5), 0, 0);
        this._radOpenInCurrentSession = warnDiscardExistingSqlEditors ? new JRadioButton(s_stringMgr.getString("OpenInSessionPanel.open.in.existing.session.warn.discard")) : new JRadioButton(s_stringMgr.getString("OpenInSessionPanel.open.in.existing.session"));
        this.add((Component)this._radOpenInCurrentSession, gbc);
    }

    public boolean isOpenInNewSession() {
        return this._radOpenInNewSession.isSelected();
    }

    public void setEnabledOpenInSessionPanel(boolean b) {
        if (null != this._lblDecide) {
            this._lblDecide.setEnabled(b);
        }
        if (null != this._multiLblDecide) {
            this._multiLblDecide.setEnabled(b);
        }
        this._radOpenInNewSession.setEnabled(b);
        this._radOpenInCurrentSession.setEnabled(b);
    }
}

