/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionMoreCtrlClosingListener;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionMoreDlg;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionMoreDlgState;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionsManager;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SavedSessionMoreCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SavedSessionMoreCtrl.class);
    public static final String PREF_KEY_FIND_REMEMBER_LAST_SEARCH = "SavedSessionMoreCtrl.remember.last.search";
    public static final String PREF_KEY_FIND_LAST_SEARCH_STRING = "SavedSessionMoreCtrl.last.search.string";
    private final SavedSessionMoreDlg _dlg;
    private ISession _session;
    private SavedSessionMoreCtrlClosingListener _closingListener;
    private SavedSessionGrouped _savedSessionGroupedToOpen;

    public SavedSessionMoreCtrl(ISession session, SavedSessionMoreCtrlClosingListener closingListener, boolean toUseByPreferencesFinderOnly) {
        SavedSessionMoreDlgState state;
        Frame owningFrame;
        this._session = session;
        this._closingListener = closingListener;
        if (null != this._session) {
            owningFrame = GUIUtils.getOwningFrame(this._session.getSessionPanel());
            state = SavedSessionMoreDlgState.CURRENT_SESSION_WARN_DISCARD_SQL_EDITORS;
            if (SavedSessionUtil.isSQLVirgin(this._session)) {
                state = SavedSessionMoreDlgState.CURRENT_SESSION;
            }
        } else {
            owningFrame = Main.getApplication().getMainFrame();
            state = SavedSessionMoreDlgState.CURRENT_SESSION_NONE;
        }
        this._dlg = new SavedSessionMoreDlg(owningFrame, state);
        this._dlg.txtToSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SavedSessionMoreCtrl.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SavedSessionMoreCtrl.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SavedSessionMoreCtrl.this.updateList();
            }
        });
        this._dlg.chkRememberLastSearch.setSelected(Props.getBoolean(PREF_KEY_FIND_REMEMBER_LAST_SEARCH, false));
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            String lastSearchString = Props.getString(PREF_KEY_FIND_LAST_SEARCH_STRING, null);
            this._dlg.txtToSearch.setText(lastSearchString);
            if (null != lastSearchString) {
                this._dlg.txtToSearch.selectAll();
            }
        }
        this.updateList();
        this._dlg.lstSavedSessions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SavedSessionMoreCtrl.this.onListClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SavedSessionMoreCtrl.this.maybeTriggerPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SavedSessionMoreCtrl.this.maybeTriggerPopup(e);
            }
        });
        this._dlg.lstSavedSessions.addListSelectionListener(e -> this.onListSelectionChanged(e));
        this.onListSelectionChanged(null);
        SavedSessionsManager savedSessionsManager = Main.getApplication().getSavedSessionsManager();
        this._dlg.chkShowDefaultAliasMsg.setSelected(savedSessionsManager.isShowAliasChangeMsg());
        this._dlg.chkShowDefaultAliasMsg.addActionListener(e -> savedSessionsManager.setShowAliasChangeMsg(this._dlg.chkShowDefaultAliasMsg.isSelected()));
        this._dlg.txtMaxNumberSavedSessions.setInt(savedSessionsManager.getMaxNumberSavedSessions());
        this._dlg.btnOpenSelected.addActionListener(e -> this.onOpenSelected());
        this._dlg.btnClose.addActionListener(e -> this.close());
        this._dlg.btnDeleteSelected.addActionListener(e -> this.onDeleteSelected());
        this._dlg.txtToSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SavedSessionMoreCtrl.this.onKeyPressed(e);
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SavedSessionMoreCtrl.this.onClosing();
            }
        });
        if (!toUseByPreferencesFinderOnly) {
            GUIUtils.enableCloseByEscape(this._dlg, dialog -> this.onClosing());
            GUIUtils.initLocation(this._dlg, 750, 750);
            GUIUtils.forceFocus(this._dlg.txtToSearch);
            this._dlg.setVisible(true);
        }
    }

    private void onListSelectionChanged(ListSelectionEvent e) {
        if (e != null && e.getValueIsAdjusting() || null == this._dlg.openInSessionPanel || null == this._dlg.lstSavedSessions.getSelectedValue()) {
            return;
        }
        this._dlg.openInSessionPanel.setEnabledOpenInSessionPanel(!this._dlg.lstSavedSessions.getSelectedValue().isGroup());
    }

    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            int selIx = this._dlg.lstSavedSessions.getSelectedIndex();
            if (0 < selIx) {
                this._dlg.lstSavedSessions.setSelectedIndex(selIx - 1);
                this._dlg.lstSavedSessions.ensureIndexIsVisible(selIx - 1);
            }
        } else if (e.getKeyCode() == 40) {
            int selIx = this._dlg.lstSavedSessions.getSelectedIndex();
            if (this._dlg.lstSavedSessions.getModel().getSize() - 1 > selIx) {
                this._dlg.lstSavedSessions.setSelectedIndex(selIx + 1);
                this._dlg.lstSavedSessions.ensureIndexIsVisible(selIx + 1);
            }
        }
    }

    private void updateList() {
        String filterText = this._dlg.txtToSearch.getText();
        List<SavedSessionGrouped> savedSessionsGrouped = Main.getApplication().getSavedSessionsManager().getSavedSessionsGrouped();
        ArrayList<SavedSessionGrouped> matchingSavedSessionsGrouped = new ArrayList<SavedSessionGrouped>();
        for (SavedSessionGrouped savedSession : savedSessionsGrouped) {
            if (!this.matches(savedSession, filterText)) continue;
            matchingSavedSessionsGrouped.add(savedSession);
        }
        this._dlg.lstSavedSessions.setListData((SavedSessionGrouped[])matchingSavedSessionsGrouped.toArray(new SavedSessionGrouped[0]));
        if (0 < this._dlg.lstSavedSessions.getModel().getSize()) {
            this._dlg.lstSavedSessions.setSelectedIndex(0);
        }
    }

    private boolean matches(SavedSessionGrouped savedSessionGrouped, String filterText) {
        if (StringUtilities.isEmpty(filterText, true)) {
            return true;
        }
        return savedSessionGrouped.matchesFilterText(filterText);
    }

    private void maybeTriggerPopup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("SavedSessionMoreCtrl.rename"));
        menuItem.addActionListener(e -> this.onRename());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("SavedSessionMoreCtrl.print.saved.session.details.msg.panel"));
        menuItem.addActionListener(e -> this.onPrintDetails());
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new JMenuItem(s_stringMgr.getString("SavedSessionMoreCtrl.delete.selected.saved.sessions.right.mouse"));
        menuItem.addActionListener(e -> this.onDeleteSelected());
        popupMenu.add(menuItem);
        popupMenu.show(this._dlg.lstSavedSessions, me.getX(), me.getY());
    }

    private void onPrintDetails() {
        SavedSessionGrouped selectedSavedSessionGrouped = this._dlg.lstSavedSessions.getSelectedValue();
        if (null == selectedSavedSessionGrouped) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("SavedSessionMoreCtrl.no.section.to.print.details"));
        }
        SavedSessionUtil.printSavedSessionDetails(selectedSavedSessionGrouped);
    }

    private void onRename() {
        String newName;
        SavedSessionGrouped savedSessionGrouped = this._dlg.lstSavedSessions.getSelectedValue();
        if (null == savedSessionGrouped) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("SavedSessionMoreCtrl.no.session.to.rename"));
        }
        if (null == (newName = SavedSessionUtil.showEditSavedSessionNameDialog(this._dlg, savedSessionGrouped.getName()))) {
            return;
        }
        savedSessionGrouped.setName(newName);
        Main.getApplication().getSavedSessionsManager().moveToTop(savedSessionGrouped);
        Main.getApplication().getMainFrame().getMainFrameTitleHandler().updateMainFrameTitle();
        this._dlg.lstSavedSessions.repaint();
    }

    private void onDeleteSelected() {
        List<SavedSessionGrouped> selectedValuesList = this._dlg.lstSavedSessions.getSelectedValuesList();
        if (0 == selectedValuesList.size()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("SavedSessionMoreCtrl.no.session.selected.to.delete"));
            return;
        }
        List<ISession> openSessions = Main.getApplication().getSavedSessionsManager().getOpenSessionsForSavedSessionsGrouped(selectedValuesList);
        if (0 < openSessions.size()) {
            if (0 != JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("SavedSessionMoreCtrl.confirm.delete.including.used.in.open"))) {
                return;
            }
            SavedSessionUtil.detachInternalFiles(openSessions);
        } else if (0 != JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("SavedSessionMoreCtrl.confirm.delete"))) {
            return;
        }
        Main.getApplication().getSavedSessionsManager().delete(selectedValuesList);
        this._dlg.lstSavedSessions.setListData((SavedSessionGrouped[])Main.getApplication().getSavedSessionsManager().getSavedSessionsGrouped().toArray(new SavedSessionGrouped[0]));
        if (0 < this._dlg.lstSavedSessions.getModel().getSize()) {
            this._dlg.lstSavedSessions.setSelectedIndex(0);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.onOpenSelected();
        }
    }

    private void onOpenSelected() {
        this._savedSessionGroupedToOpen = this._dlg.lstSavedSessions.getSelectedValue();
        if (null == this._savedSessionGroupedToOpen) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("SavedSessionMoreCtrl.no.saved.session.selected.to.open"));
            return;
        }
        this.close();
    }

    private void close() {
        this.onClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private boolean isOpenInNewSession() {
        if (null == this._dlg.openInSessionPanel) {
            return true;
        }
        return this._dlg.openInSessionPanel.isOpenInNewSession();
    }

    private void onClosing() {
        Main.getApplication().getSavedSessionsManager().setMaxNumberSavedSessions(this._dlg.txtMaxNumberSavedSessions.getInt());
        Props.putBoolean(PREF_KEY_FIND_REMEMBER_LAST_SEARCH, this._dlg.chkRememberLastSearch.isSelected());
        if (this._dlg.chkRememberLastSearch.isSelected()) {
            Props.putString(PREF_KEY_FIND_LAST_SEARCH_STRING, this._dlg.txtToSearch.getText());
        }
        if (null != this._closingListener) {
            this._closingListener.closed(this._savedSessionGroupedToOpen, this.isOpenInNewSession());
        }
    }

    public String getTitle() {
        return this._dlg.getTitle();
    }

    public Container getContentPane() {
        return this._dlg.getContentPane();
    }

    public void toFront() {
        this._dlg.toFront();
    }
}

