/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.Window;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SQLPanelSaveInfo;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionManageAction;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSqlJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SqlPanelType;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.ResizableTextEditDialog;
import net.sourceforge.squirrel_sql.fw.id.UidIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SavedSessionUtil {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SavedSessionUtil.class);

    public static List<SQLPanelSaveInfo> getAllSQLPanelsOrderedAndTyped(ISession session) {
        IWidget[] allWidgets;
        ArrayList<SQLPanelSaveInfo> ret = new ArrayList<SQLPanelSaveInfo>();
        if (session.isClosed()) {
            return ret;
        }
        SQLPanelSaveInfo mainSqlPanelSaveInfo = new SQLPanelSaveInfo(session.getSessionPanel().getMainSQLPanel(), SqlPanelType.MAIN_SQL_TAB);
        ret.add(mainSqlPanelSaveInfo);
        if (session.getSessionPanel().getMainSQLPanel().getSQLPanelAPI() == session.getSQLPanelAPIOfActiveSessionWindow()) {
            mainSqlPanelSaveInfo.setActiveSqlPanel(session.getSessionPanel().getMainSQLPanel().getSQLPanelAPI().getCaretPosition());
        }
        for (AdditionalSQLTab additionalSQLTab : session.getSessionPanel().getAdditionalSQLTabs()) {
            SQLPanelSaveInfo sqlPanelSaveInfo = new SQLPanelSaveInfo(additionalSQLTab.getSQLPanel(), SqlPanelType.SQL_TAB);
            sqlPanelSaveInfo.setSqlTabTitleWithoutFile(additionalSQLTab.getTitleWithoutFile());
            if (additionalSQLTab.getSQLPanel().getSQLPanelAPI() == session.getSQLPanelAPIOfActiveSessionWindow()) {
                sqlPanelSaveInfo.setActiveSqlPanel(additionalSQLTab.getSQLPanel().getSQLPanelAPI().getCaretPosition());
            }
            ret.add(sqlPanelSaveInfo);
        }
        for (IWidget widget : allWidgets = Main.getApplication().getMainFrame().getDesktopContainer().getAllWidgets()) {
            if (!(widget instanceof SQLInternalFrame)) continue;
            SQLPanel sqlWorksheetPanel = ((SQLInternalFrame)widget).getSQLPanel();
            ISession sessionOfSqlInternaFrame = sqlWorksheetPanel.getSession();
            if (!session.getIdentifier().equals(sessionOfSqlInternaFrame.getIdentifier())) continue;
            SQLPanelSaveInfo sqlPanelSaveInfo = new SQLPanelSaveInfo(sqlWorksheetPanel, SqlPanelType.SQL_INTERNAL_FRAME);
            if (Main.getApplication().getMainFrame().getDesktopContainer().getSelectedWidget() == widget) {
                sqlPanelSaveInfo.setActiveSqlPanel(sqlWorksheetPanel.getSQLPanelAPI().getCaretPosition());
            }
            ret.add(sqlPanelSaveInfo);
        }
        return ret;
    }

    public static boolean isSQLVirgin(ISession session) {
        List<SQLPanelSaveInfo> sqlPanelSaveInfoList = SavedSessionUtil.getAllSQLPanelsOrderedAndTyped(session);
        if (1 < sqlPanelSaveInfoList.size()) {
            return false;
        }
        ISQLPanelAPI sqlPanelAPI = sqlPanelSaveInfoList.get(0).getSqlPanel().getSQLPanelAPI();
        return null == sqlPanelAPI.getFileHandler().getFile() && StringUtilities.isEmpty(sqlPanelAPI.getEntireSQLScript(), true);
    }

    public static void makeSessionSQLVirgin(ISession session) {
        IWidget[] allWidgets;
        SQLPanel mainSQLPanel = session.getSessionPanel().getMainSQLPanel();
        mainSQLPanel.getSQLPanelAPI().getFileHandler().resetUnsavedEdits();
        mainSQLPanel.getSQLPanelAPI().getFileHandler().fileClose();
        mainSQLPanel.getSQLPanelAPI().setEntireSQLScript(null);
        for (AdditionalSQLTab additionalSQLTab : session.getSessionPanel().getAdditionalSQLTabs()) {
            additionalSQLTab.getSQLPanelAPI().getFileHandler().resetUnsavedEdits();
            additionalSQLTab.getSQLPanelAPI().getFileHandler().fileClose();
            additionalSQLTab.close(true);
        }
        for (IWidget widget : allWidgets = Main.getApplication().getMainFrame().getDesktopContainer().getAllWidgets()) {
            if (!(widget instanceof SQLInternalFrame)) continue;
            ISession sessionOfSqlInternaFrame = ((SQLInternalFrame)widget).getSQLPanel().getSession();
            if (!session.getIdentifier().equals(sessionOfSqlInternaFrame.getIdentifier())) continue;
            ((SQLInternalFrame)widget).getMainSQLPanelAPI().getFileHandler().resetUnsavedEdits();
            ((SQLInternalFrame)widget).getMainSQLPanelAPI().getFileHandler().fileClose();
            ((SQLInternalFrame)widget).closeFrame(true);
        }
    }

    public static void initSessionWithSavedSession(SavedSessionJsonBean savedSessionJsonBean, ISession session) {
        session.setSavedSession(savedSessionJsonBean);
        ((SessionManageAction)Main.getApplication().getActionCollection().get(SessionManageAction.class)).updateUI();
    }

    public static SQLAlias getAliasForIdString(String defaultAliasIdString) {
        UidIdentifier aliasId = new UidIdentifier(defaultAliasIdString);
        return Main.getApplication().getAliasesAndDriversManager().getAlias(aliasId);
    }

    public static boolean isInSavedSessionsDir(File sqlFile) {
        if (null == sqlFile) {
            return false;
        }
        return SavedSessionUtil.getSavedSessionsDir().equals(sqlFile.getParentFile());
    }

    public static File getSavedSessionsDir() {
        return new ApplicationFiles().getSavedSessionsDir();
    }

    public static void printSavedSessionDetails(SavedSessionGrouped savedSessionGrouped) {
        StringBuilder msgSb = new StringBuilder();
        if (savedSessionGrouped.isGroup()) {
            String msg = s_stringMgr.getString("SavedSessionUtil.saved.session.group", savedSessionGrouped.getGroup().getGroupName());
            SavedSessionUtil.appendWithNewLine(msgSb, msg);
        }
        for (int i = 0; i < savedSessionGrouped.getSavedSessions().size(); ++i) {
            String msg;
            SavedSessionJsonBean savedSession = savedSessionGrouped.getSavedSessions().get(i);
            String savedSessionName = savedSession.getName();
            SQLAlias alias = SavedSessionUtil.getAliasForIdString(savedSession.getDefaultAliasIdString());
            String aliasName = "<unknown>";
            String jdbcUrl = "<unknown>";
            String jdbcUser = "<unknown>";
            if (null != alias) {
                aliasName = alias.getName();
                jdbcUrl = alias.getUrl();
                jdbcUser = alias.getUserName();
            }
            if (savedSessionGrouped.isGroup()) {
                msg = s_stringMgr.getString("SavedSessionUtil.saved.session.in.group.details", i + 1, aliasName, jdbcUrl, jdbcUser);
                SavedSessionUtil.appendWithNewLine(msgSb, msg);
            } else {
                msg = s_stringMgr.getString("SavedSessionUtil.saved.session.details", savedSessionName, aliasName, jdbcUrl, jdbcUser);
                SavedSessionUtil.appendWithNewLine(msgSb, msg);
            }
            boolean firstInternalFile = true;
            for (SessionSqlJsonBean sessionSQL : savedSession.getSessionSQLs()) {
                String fileMsg;
                if (!StringUtilities.isEmpty(sessionSQL.getExternalFilePath())) {
                    fileMsg = s_stringMgr.getString("SavedSessionUtil.saved.session.external.file", sessionSQL.getExternalFilePath());
                } else if (firstInternalFile) {
                    fileMsg = s_stringMgr.getString("SavedSessionUtil.saved.session.internal.file.first", sessionSQL.getInternalFileName(), SavedSessionUtil.getSavedSessionsDir());
                    firstInternalFile = false;
                } else {
                    fileMsg = s_stringMgr.getString("SavedSessionUtil.saved.session.internal.file", sessionSQL.getInternalFileName());
                }
                SavedSessionUtil.appendWithNewLine(msgSb, fileMsg);
            }
        }
        if (0 < msgSb.length()) {
            Main.getApplication().getMessageHandler().showMessage(msgSb.toString());
        }
    }

    private static void appendWithNewLine(StringBuilder msgSb, String msg) {
        if (0 < msgSb.length()) {
            msgSb.append('\n');
        }
        msgSb.append(msg);
    }

    public static String getDisplayString(SavedSessionGrouped value) {
        Object ret = "";
        if (value.isGroup()) {
            ret = s_stringMgr.getString("SavedSessionUtil.group.title", value.getName());
        }
        for (SavedSessionJsonBean savedSession : value.getSavedSessions()) {
            String aliasName = "<unknown>";
            String aliasUrl = "<unknown>";
            String aliasUserName = "<unknown>";
            SQLAlias alias = SavedSessionUtil.getAliasForIdString(savedSession.getDefaultAliasIdString());
            if (null != alias) {
                aliasName = alias.getName();
                aliasUrl = alias.getUrl();
                aliasUserName = alias.getUserName();
            }
            if (value.isGroup()) {
                ret = (String)ret + s_stringMgr.getString("SavedSessionUtil.saved.session.in.group.display.name", "   ", aliasName, aliasUrl, aliasUserName);
                continue;
            }
            ret = (String)ret + s_stringMgr.getString("SavedSessionUtil.saved.session.display.name", value.getName(), aliasName, aliasUrl, aliasUserName);
        }
        return ret;
    }

    public static String createSavedSessionNameTemplate(ISession session) {
        String savedSessionNameTemplate = SavedSessionUtil.createSessionName(session) + SavedSessionUtil.createDatePostfix();
        return savedSessionNameTemplate;
    }

    public static String createSessionGroupNameTemplate(List<ISession> sessions) {
        Object ret = "Group of [";
        for (int i = 0; i < sessions.size(); ++i) {
            if (0 < i) {
                ret = (String)ret + " | ";
            }
            ISession session = sessions.get(i);
            ret = (String)ret + SavedSessionUtil.createSessionName(session);
        }
        ret = (String)ret + "]" + SavedSessionUtil.createDatePostfix();
        return ret;
    }

    private static String createDatePostfix() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return " | " + df.format(new Date());
    }

    private static String createSessionName(ISession session) {
        return session.getAlias().getName();
    }

    public static String getMainFrameTitleString(SavedSessionJsonBean savedSession) {
        if (null == savedSession) {
            throw new IllegalArgumentException("Don't call with param null");
        }
        if (StringUtilities.isEmpty(savedSession.getGroupId(), true)) {
            return s_stringMgr.getString("SavedSessionUtil.saved.session.mainframe.title", savedSession.getName());
        }
        SavedSessionsGroupJsonBean group = Main.getApplication().getSavedSessionsManager().getGroup(savedSession.getGroupId());
        return s_stringMgr.getString("SavedSessionUtil.in.saved.session.group.mainframe.title", group.getGroupName());
    }

    public static String showEditSavedSessionNameDialog(Window parent, String defaultName) {
        return SavedSessionUtil.showEditSavedSessionNameDialog(parent, defaultName, null);
    }

    public static String showEditSavedSessionNameDialog(Window parent, String defaultName, SavedSessionJsonBean toExcludeFromSameNameCheck) {
        return SavedSessionUtil.showEditSavedSessionNameDialog(parent, defaultName, toExcludeFromSameNameCheck, null);
    }

    public static String showEditSavedSessionNameDialog(Window parent, String defaultName, SavedSessionJsonBean toExcludeFromSameNameCheck, String customTitle) {
        ResizableTextEditDialog sessionSaveDlg = new ResizableTextEditDialog(parent, SavedSessionUtil.class.getName(), StringUtilities.isEmpty(customTitle, true) ? s_stringMgr.getString("SessionSaveDlg.title") : customTitle, s_stringMgr.getString("SessionSaveDlg.label"), defaultName, (resizableTextEditDialog, editedText) -> SavedSessionUtil.onEditSavedSessionNameCheck(resizableTextEditDialog, editedText, toExcludeFromSameNameCheck));
        if (!sessionSaveDlg.isOk()) {
            return null;
        }
        return sessionSaveDlg.getEditedText();
    }

    private static boolean onEditSavedSessionNameCheck(ResizableTextEditDialog textEditDialog, String editedText, SavedSessionJsonBean toExcludeFromSameNameCheck) {
        if (Main.getApplication().getSavedSessionsManager().doesNameExist(editedText.trim(), toExcludeFromSameNameCheck)) {
            JOptionPane.showMessageDialog(textEditDialog, s_stringMgr.getString("SessionSaveDlg.nonunique.name"));
            return false;
        }
        return true;
    }

    public static void detachInternalFiles(ISession session) {
        SavedSessionUtil.detachInternalFiles(List.of(session));
    }

    public static void detachInternalFiles(List<ISession> sessions) {
        for (ISession session : sessions) {
            List<SQLPanelSaveInfo> sqlPanelSaveInfos = SavedSessionUtil.getAllSQLPanelsOrderedAndTyped(session);
            for (SQLPanelSaveInfo sqlPanelSaveInfo : sqlPanelSaveInfos) {
                File file = sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().getFile();
                if (!SavedSessionUtil.isInSavedSessionsDir(file)) continue;
                sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().fileDetach(true);
            }
        }
    }
}

