/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SQLPanelSaveInfo;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionsJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSaveProcessHandle;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSqlJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGroupsJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.GitHandler;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class SavedSessionsManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SavedSessionsManager.class);
    private static final ILogger s_log = LoggerController.createLogger(SavedSessionsManager.class);
    private SavedSessionsJsonBean _savedSessionsJsonBean = null;
    private SavedSessionGroupsJsonBean _savedSessionGroupsJsonBean = null;
    private ExecutorService _singleThreadJsonWriteExecutorService;

    public boolean doesNameExist(String newSessionName, SavedSessionJsonBean toExcludeFromSameNameCheck) {
        this.initSavedSessions();
        for (SavedSessionJsonBean savedSessionJsonBean : this._savedSessionsJsonBean.getSavedSessionJsonBeans()) {
            if (savedSessionJsonBean == toExcludeFromSameNameCheck || !StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(savedSessionJsonBean.getName(), newSessionName, true)) continue;
            return true;
        }
        return false;
    }

    public boolean isShowAliasChangeMsg() {
        this.initSavedSessions();
        return this._savedSessionsJsonBean.isShowAliasChangeMsg();
    }

    public void setShowAliasChangeMsg(boolean b) {
        this.initSavedSessions();
        this._savedSessionsJsonBean.setShowAliasChangeMsg(b);
    }

    public SessionSaveProcessHandle beginStore(SavedSessionJsonBean savedSessionJsonBean, boolean clearSessionSqls) {
        this.initSavedSessions();
        SessionSaveProcessHandle ret = new SessionSaveProcessHandle(savedSessionJsonBean);
        if (clearSessionSqls) {
            savedSessionJsonBean.getSessionSQLs().clear();
        }
        return ret;
    }

    private void deleteAllInternallyStoredFiles(SavedSessionJsonBean savedSessionJsonBean) {
        for (SessionSqlJsonBean sessionSQL : savedSessionJsonBean.getSessionSQLs()) {
            this.deleteInternallyStoredFile(sessionSQL);
        }
    }

    private void deleteInternallyStoredFile(SessionSqlJsonBean sessionSQL) {
        if (!StringUtilities.isEmpty(sessionSQL.getInternalFileName())) {
            File toDelete = new File(SavedSessionUtil.getSavedSessionsDir(), sessionSQL.getInternalFileName());
            try {
                Files.deleteIfExists(Path.of(toDelete.toURI()));
                GitHandler.commitDelete(toDelete);
            }
            catch (Exception e) {
                s_log.error("Failed to delete internal saved session file: " + toDelete.getAbsolutePath(), e);
            }
        }
    }

    public SessionSqlJsonBean storeFile(SavedSessionJsonBean savedSessionJsonBean, SQLPanelSaveInfo sqlPanelSaveInfo, boolean gitCommit) {
        SessionSqlJsonBean sqlJsonBean = new SessionSqlJsonBean();
        sqlJsonBean.setPanelType(sqlPanelSaveInfo.getSqlPanelType());
        sqlJsonBean.setSqlTabTitleWithoutFile(sqlPanelSaveInfo.getSqlTabTitleWithoutFile());
        sqlJsonBean.setActiveSqlPanel(sqlPanelSaveInfo.isActiveSqlPanel());
        sqlJsonBean.setCaretPosition(sqlPanelSaveInfo.getCaretPosition());
        if (null != sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().getFile()) {
            if (gitCommit) {
                ChangeTrackUtil.gitCommitSqlPanel(sqlPanelSaveInfo.getSqlPanel(), sqlPanelSaveInfo.isActiveSqlPanel());
            } else {
                sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().fileSave();
            }
            if (SavedSessionUtil.isInSavedSessionsDir(sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().getFile())) {
                sqlJsonBean.setInternalFileName(sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().getFile().getName());
            } else {
                sqlJsonBean.setExternalFilePath(sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().getFile().getAbsolutePath());
            }
        } else {
            String internalFileNameOrig = StringUtilities.javaNormalize(savedSessionJsonBean.getName(), false) + "_" + savedSessionJsonBean.getSessionSQLs().size();
            int emergencyPosFix = 0;
            String internalFileName = internalFileNameOrig + ".sql";
            while (Files.exists(Path.of(new File(SavedSessionUtil.getSavedSessionsDir(), internalFileName).toURI()), new LinkOption[0])) {
                internalFileName = internalFileNameOrig + "__" + ++emergencyPosFix + ".sql";
            }
            sqlJsonBean.setInternalFileName(internalFileName);
            Path path = Path.of(SavedSessionUtil.getSavedSessionsDir().getAbsolutePath(), internalFileName);
            try {
                sqlPanelSaveInfo.getSqlPanel().getSQLPanelAPI().getFileHandler().fileSaveInitiallyTo(path.toFile());
                if (gitCommit) {
                    ChangeTrackUtil.gitCommitSqlPanel(sqlPanelSaveInfo.getSqlPanel(), sqlPanelSaveInfo.isActiveSqlPanel());
                }
            }
            catch (Exception e) {
                s_log.error("Error while saving Session: Failed to internally save SQL editor contents to internal file : " + path.toFile().getAbsolutePath(), e);
            }
        }
        savedSessionJsonBean.getSessionSQLs().add(sqlJsonBean);
        return sqlJsonBean;
    }

    public void endStore(SavedSessionJsonBean savedSessionJsonBean, SavedSessionsGroupJsonBean group, SessionSaveProcessHandle sessionSaveProcessHandle) {
        if (null != group && !this._savedSessionGroupsJsonBean.getGroups().stream().anyMatch(g -> StringUtils.equals((CharSequence)g.getGroupId(), (CharSequence)group.getGroupId()))) {
            this._savedSessionGroupsJsonBean.getGroups().add(group);
        }
        sessionSaveProcessHandle.getToDelete(savedSessionJsonBean).forEach(b -> this.deleteInternallyStoredFile((SessionSqlJsonBean)b));
        this._savedSessionsJsonBean.getSavedSessionJsonBeans().remove(savedSessionJsonBean);
        this._savedSessionsJsonBean.getSavedSessionJsonBeans().add(0, savedSessionJsonBean);
        this.saveJsonBeans();
    }

    private void saveJsonBeans() {
        this.consolidateGroups();
        this._singleThreadJsonWriteExecutorService.submit(() -> this.saveFiles());
    }

    private void consolidateGroups() {
        this.initSavedSessions();
        Set groupIdsInSavedSessions = this._savedSessionsJsonBean.getSavedSessionJsonBeans().stream().filter(s -> false == StringUtilities.isEmpty(s.getGroupId(), true)).map(s -> s.getGroupId()).collect(Collectors.toSet());
        HashSet<String> uniqueGroupIds = new HashSet<String>();
        ArrayList<SavedSessionsGroupJsonBean> groupsToRemove = new ArrayList<SavedSessionsGroupJsonBean>();
        for (SavedSessionsGroupJsonBean group : this._savedSessionGroupsJsonBean.getGroups()) {
            if (!groupIdsInSavedSessions.contains(group.getGroupId())) {
                groupsToRemove.add(group);
                continue;
            }
            if (uniqueGroupIds.contains(group.getGroupId())) {
                groupsToRemove.add(group);
            }
            uniqueGroupIds.add(group.getGroupId());
        }
        this._savedSessionGroupsJsonBean.getGroups().removeAll(groupsToRemove);
    }

    private void saveFiles() {
        JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getSavedSessionsJsonFile(), this._savedSessionsJsonBean);
        JsonMarshalUtil.writeObjectToFile(new ApplicationFiles().getSavedSessionGroupsJsonFile(), this._savedSessionGroupsJsonBean);
    }

    public List<SavedSessionGrouped> getSavedSessionsGrouped() {
        this.initSavedSessions();
        ArrayList<SavedSessionGrouped> ret = new ArrayList<SavedSessionGrouped>();
        for (SavedSessionJsonBean savedSessionJsonBean : this._savedSessionsJsonBean.getSavedSessionJsonBeans()) {
            if (StringUtilities.isEmpty(savedSessionJsonBean.getGroupId(), true)) {
                ret.add(new SavedSessionGrouped(savedSessionJsonBean));
                continue;
            }
            SavedSessionsGroupJsonBean group = this.getGroup(savedSessionJsonBean.getGroupId());
            SavedSessionGrouped savedSessionGrouped = ret.stream().filter(ssg -> SavedSessionsManager.matchGroup(ssg, group)).findFirst().orElse(null);
            if (null != savedSessionGrouped) {
                savedSessionGrouped.addSavedSession(savedSessionJsonBean);
                continue;
            }
            if (null == group) continue;
            ret.add(new SavedSessionGrouped(savedSessionJsonBean, group));
        }
        return ret;
    }

    public SavedSessionGrouped getSavedSessionGrouped(String groupId) {
        return this.getSavedSessionsGrouped().stream().filter(g -> null != g.getGroup() && StringUtils.equals((CharSequence)g.getGroup().getGroupId(), (CharSequence)groupId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find group by groupId=" + groupId));
    }

    public SavedSessionGrouped getSavedSessionGrouped(SavedSessionJsonBean savedSession) {
        if (StringUtilities.isEmpty(savedSession.getGroupId(), true)) {
            return SavedSessionGrouped.of(savedSession);
        }
        return this.getSavedSessionGrouped(savedSession.getGroupId());
    }

    private static boolean matchGroup(SavedSessionGrouped savedSessionGrouped, SavedSessionsGroupJsonBean savedSessionsGroupJsonBean) {
        if (null == savedSessionGrouped || !savedSessionGrouped.isGroup() || null == savedSessionsGroupJsonBean) {
            return false;
        }
        return StringUtils.equals((CharSequence)savedSessionGrouped.getGroup().getGroupId(), (CharSequence)savedSessionsGroupJsonBean.getGroupId());
    }

    private void initSavedSessions() {
        if (null == this._savedSessionsJsonBean) {
            File savedSessionsJsonFile = new ApplicationFiles().getSavedSessionsJsonFile();
            this._savedSessionsJsonBean = savedSessionsJsonFile.exists() ? JsonMarshalUtil.readObjectFromFileSave(savedSessionsJsonFile, SavedSessionsJsonBean.class, new SavedSessionsJsonBean()) : new SavedSessionsJsonBean();
            File jsonFile = new ApplicationFiles().getSavedSessionGroupsJsonFile();
            this._savedSessionGroupsJsonBean = jsonFile.exists() ? JsonMarshalUtil.readObjectFromFileSave(jsonFile, SavedSessionGroupsJsonBean.class, new SavedSessionGroupsJsonBean()) : new SavedSessionGroupsJsonBean();
            this._singleThreadJsonWriteExecutorService = Executors.newSingleThreadExecutor();
            this.checkMaxSavedSessionLimit();
        }
    }

    private void checkMaxSavedSessionLimit() {
        List<SavedSessionGrouped> allSavedSessionsGrouped = this.getSavedSessionsGrouped();
        if (0 == this._savedSessionsJsonBean.getMaxNumberSavedSessions() || allSavedSessionsGrouped.size() <= this._savedSessionsJsonBean.getMaxNumberSavedSessions()) {
            return;
        }
        List<SavedSessionGrouped> toDel = allSavedSessionsGrouped.subList(this._savedSessionsJsonBean.getMaxNumberSavedSessions(), allSavedSessionsGrouped.size());
        String msg = s_stringMgr.getString("SavedSessionsManager.maximum.number.saved.sessions.exceeded", this._savedSessionsJsonBean.getMaxNumberSavedSessions(), toDel.size());
        Main.getApplication().getMessageHandler().showMessage(msg);
        s_log.info(msg);
        this.delete(toDel);
    }

    public void moveToTop(SavedSessionGrouped savedSessionGrouped) {
        this.initSavedSessions();
        for (SavedSessionJsonBean savedSession : savedSessionGrouped.getSavedSessions()) {
            this._savedSessionsJsonBean.getSavedSessionJsonBeans().remove(savedSession);
            this._savedSessionsJsonBean.getSavedSessionJsonBeans().add(0, savedSession);
        }
        this.saveJsonBeans();
    }

    public List<ISession> getOpenSessionsForSavedSessionsGrouped(List<SavedSessionGrouped> savedSessionsGrouped) {
        this.initSavedSessions();
        ArrayList<ISession> ret = new ArrayList<ISession>();
        for (SavedSessionGrouped savedSessionGrouped : savedSessionsGrouped) {
            ret.addAll(Main.getApplication().getSessionManager().getOpenSessions().stream().filter(s -> savedSessionGrouped.getSavedSessions().contains(s.getSavedSession())).collect(Collectors.toList()));
        }
        return ret;
    }

    public void delete(SavedSessionGrouped toDel) {
        this.delete(List.of(toDel));
    }

    public void delete(List<SavedSessionGrouped> toDelList) {
        this.initSavedSessions();
        for (ISession session : Main.getApplication().getSessionManager().getOpenSessions()) {
            for (SavedSessionGrouped toDel : toDelList) {
                if (!toDel.containsSavedSession(session.getSavedSession())) continue;
                SavedSessionUtil.initSessionWithSavedSession(null, session);
            }
        }
        for (SavedSessionGrouped toDel : toDelList) {
            toDel.getSavedSessions().forEach(savedSess -> this.deleteAllInternallyStoredFiles((SavedSessionJsonBean)savedSess));
        }
        for (SavedSessionGrouped toDel : toDelList) {
            this._savedSessionsJsonBean.getSavedSessionJsonBeans().removeAll(toDel.getSavedSessions());
        }
        for (SavedSessionGrouped toDel : toDelList) {
            if (!toDel.isGroup()) continue;
            this._savedSessionGroupsJsonBean.getGroups().removeIf(g -> StringUtils.equals((CharSequence)g.getGroupId(), (CharSequence)toDel.getGroup().getGroupId()));
        }
        this.saveJsonBeans();
    }

    public int getMaxNumberSavedSessions() {
        return this._savedSessionsJsonBean.getMaxNumberSavedSessions();
    }

    public void setMaxNumberSavedSessions(int maxNumberSavedSessions) {
        this._savedSessionsJsonBean.setMaxNumberSavedSessions(maxNumberSavedSessions);
        this.saveJsonBeans();
    }

    public SavedSessionsGroupJsonBean getGroup(String groupId) {
        this.initSavedSessions();
        return this._savedSessionGroupsJsonBean.getGroups().stream().filter(g -> StringUtils.equals((CharSequence)g.getGroupId(), (CharSequence)groupId)).findFirst().orElse(null);
    }

    public void removeGroupIfEmpty(String groupId) {
        this.initSavedSessions();
        boolean save = false;
        if (!this._savedSessionsJsonBean.getSavedSessionJsonBeans().stream().anyMatch(s -> StringUtils.equals((CharSequence)s.getGroupId(), (CharSequence)groupId)) && this._savedSessionGroupsJsonBean.getGroups().removeIf(g -> StringUtils.equals((CharSequence)g.getGroupId(), (CharSequence)groupId))) {
            save = true;
        }
        if (save) {
            this.saveJsonBeans();
        }
    }
}

