/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ActionUtil;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionPersister;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SessionManageAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionManageAction.class);
    private ISession _session;

    public SessionManageAction(IApplication app) {
        super(app);
        this.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof JButton) {
            JMenuItem item;
            JPopupMenu popupMenu = new JPopupMenu();
            if (StringUtilities.isEmpty(this._session.getSavedSession().getGroupId(), true)) {
                item = new JMenuItem(s_stringMgr.getString("SessionManageAction.rename.session", this._session.getSavedSession().getName()));
                item.addActionListener(e -> this.onRenameSavedSession());
                popupMenu.add(item);
                item = new JMenuItem(s_stringMgr.getString("SessionManageAction.save.as.new.session", this._session.getSavedSession().getName()));
                item.addActionListener(e -> this.onSaveAsNewSavedSession());
                popupMenu.add(item);
            }
            if (StringUtilities.isEmpty(this._session.getSavedSession().getGroupId(), true)) {
                item = new JMenuItem(s_stringMgr.getString("SessionManageAction.print.saved.session.details.msg.panel", this._session.getSavedSession().getName()));
            } else {
                SavedSessionsGroupJsonBean group = Main.getApplication().getSavedSessionsManager().getGroup(this._session.getSavedSession().getGroupId());
                item = new JMenuItem(s_stringMgr.getString("SessionManageAction.print.saved.session.in.group.details.msg.panel", group.getGroupName()));
            }
            item.addActionListener(e -> this.onPrintDetailsToMessagePanel());
            popupMenu.add(item);
            String sessionOpenAccel = ActionUtil.getAcceleratorString(Main.getApplication().getResources(), Main.getApplication().getActionCollection().get(SessionOpenAction.class));
            item = new JMenuItem(s_stringMgr.getString("SessionManageAction.more", sessionOpenAccel));
            item.addActionListener(e -> this.onOpenManageSavedSessionDialog());
            popupMenu.add(item);
            JButton toolBarButton = (JButton)ae.getSource();
            popupMenu.show(toolBarButton, 0, toolBarButton.getHeight());
        }
    }

    private void onOpenManageSavedSessionDialog() {
        ((SessionOpenAction)Main.getApplication().getActionCollection().get(SessionOpenAction.class)).onOpenSavedSessionsMoreDialog();
    }

    private void onPrintDetailsToMessagePanel() {
        SavedSessionGrouped savedSessionsGroup = Main.getApplication().getSavedSessionsManager().getSavedSessionGrouped(this._session.getSavedSession());
        SavedSessionUtil.printSavedSessionDetails(savedSessionsGroup);
    }

    private void onSaveAsNewSavedSession() {
        SavedSessionJsonBean buf = this._session.getSavedSession();
        this._session.setSavedSession(null);
        if (!SessionPersister.saveSession(this._session)) {
            this._session.setSavedSession(buf);
        }
    }

    private void onRenameSavedSession() {
        SavedSessionGrouped savedSessionGrouped = Main.getApplication().getSavedSessionsManager().getSavedSessionGrouped(this._session.getSavedSession());
        String newName = SavedSessionUtil.showEditSavedSessionNameDialog(Main.getApplication().getMainFrame(), savedSessionGrouped.getName());
        if (null == newName) {
            return;
        }
        this._session.getSavedSession().setName(newName);
        Main.getApplication().getSavedSessionsManager().moveToTop(savedSessionGrouped);
        Main.getApplication().getMainFrame().getMainFrameTitleHandler().updateMainFrameTitle();
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
        this.updateUI();
    }

    public void updateUI() {
        this.setEnabled(null != this._session && null != this._session.getSavedSession());
    }
}

