/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.gui.session.IToolsPopupDescription;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ActionUtil;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.OpenInSessionDlg;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionLoader;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionMoreCtrlSingleton;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.MultipleSavedSessionOpener;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class SessionOpenAction
extends SquirrelAction
implements ISessionAction,
IToolsPopupDescription {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionOpenAction.class);
    private ISession _session;

    public SessionOpenAction(IApplication app) {
        super(app);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        List<SavedSessionGrouped> savedSessionsGrouped = Main.getApplication().getSavedSessionsManager().getSavedSessionsGrouped();
        if (ae.getSource() instanceof JButton) {
            JPopupMenu popupMenu = new JPopupMenu();
            for (int i = 0; i < Math.min(10, savedSessionsGrouped.size()); ++i) {
                SavedSessionGrouped savedSessionGrouped = savedSessionsGrouped.get(i);
                JMenuItem item = new JMenuItem(savedSessionGrouped.getName(), this.getIcon(savedSessionGrouped));
                item.addActionListener(e -> this.onOpenSavedSessionGrouped(savedSessionGrouped, this._session, false));
                popupMenu.add(item);
            }
            String sessionOpenAccel = ActionUtil.getAcceleratorString(Main.getApplication().getResources(), Main.getApplication().getActionCollection().get(SessionOpenAction.class));
            JMenuItem item = new JMenuItem(s_stringMgr.getString("SessionOpenAction.popup.more", sessionOpenAccel));
            item.addActionListener(e -> this.onOpenSavedSessionsMoreDialog());
            popupMenu.add(item);
            JButton toolBarButton = (JButton)ae.getSource();
            popupMenu.show(toolBarButton, 0, toolBarButton.getHeight());
        } else {
            this.onOpenSavedSessionsMoreDialog();
        }
    }

    private ImageIcon getIcon(SavedSessionGrouped savedSessionGrouped) {
        if (savedSessionGrouped.isGroup()) {
            return Main.getApplication().getResources().getIcon("session-group-save");
        }
        return Main.getApplication().getResources().getIcon("session");
    }

    public void onOpenSavedSessionsMoreDialog() {
        SavedSessionMoreCtrlSingleton.openDialog(this._session, (ssg, inNewSess) -> this.onSavedSessionMoreResultReceived(ssg, inNewSess));
    }

    private void onSavedSessionMoreResultReceived(SavedSessionGrouped savedSessionGrouped, boolean openInNewSession) {
        if (null != savedSessionGrouped) {
            if (openInNewSession) {
                this.onOpenSavedSessionGrouped(savedSessionGrouped, null, true);
            } else {
                this.onOpenSavedSessionGrouped(savedSessionGrouped, this._session, true);
            }
        }
    }

    private void onOpenSavedSessionGrouped(SavedSessionGrouped savedSessionGrouped, ISession session, boolean silent) {
        MainFrame mainFrame = Main.getApplication().getMainFrame();
        if (null != session && !savedSessionGrouped.isGroup()) {
            if (!silent) {
                OpenInSessionDlg openInSessionDlg = new OpenInSessionDlg(mainFrame, savedSessionGrouped.getName(), false == SavedSessionUtil.isSQLVirgin(session));
                if (!openInSessionDlg.isOk()) {
                    return;
                }
                if (openInSessionDlg.isOpenInNewSession()) {
                    this.onOpenSavedSessionGrouped(savedSessionGrouped, null, silent);
                    return;
                }
            }
            SavedSessionUtil.makeSessionSQLVirgin(session);
            this.loadSavedSession(session.getSessionInternalFrame(), savedSessionGrouped.getNoGroupedSavedSession());
        } else {
            boolean groupIsOpened;
            if (savedSessionGrouped.isGroup() && (groupIsOpened = Main.getApplication().getSessionManager().getOpenSessions().stream().anyMatch(s -> null != s.getSavedSession() && StringUtils.equals((CharSequence)s.getSavedSession().getGroupId(), (CharSequence)savedSessionGrouped.getGroup().getGroupId())))) {
                JOptionPane.showMessageDialog(Main.getApplication().getMainFrame(), s_stringMgr.getString("SessionOpenAction.group.is.open.message", savedSessionGrouped.getGroup().getGroupName()));
                return;
            }
            ArrayList<SavedSessionJsonBean> savedSessionsToOpen = new ArrayList<SavedSessionJsonBean>();
            for (SavedSessionJsonBean savedSession : savedSessionGrouped.getSavedSessions()) {
                SQLAlias alias = SavedSessionUtil.getAliasForIdString(savedSession.getDefaultAliasIdString());
                if (null == alias) {
                    if (savedSessionGrouped.isGroup()) {
                        JOptionPane.showMessageDialog(mainFrame, s_stringMgr.getString("SessionOpenAction.missing.alias.for.group"));
                        continue;
                    }
                    JOptionPane.showMessageDialog(mainFrame, s_stringMgr.getString("SessionOpenAction.missing.alias"));
                    continue;
                }
                savedSessionsToOpen.add(savedSession);
            }
            MultipleSavedSessionOpener.openSavedSessions(savedSessionsToOpen);
        }
    }

    private void loadSavedSession(SessionInternalFrame sessionInternalFrame, SavedSessionJsonBean savedSessionJsonBean) {
        SavedSessionLoader.load(sessionInternalFrame, savedSessionJsonBean);
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
    }

    @Override
    public String getToolsPopupDescription() {
        return s_stringMgr.getString("SessionOpenAction.tools.popup.description");
    }
}

