/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession;

import java.awt.Window;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SQLEditorActivator;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SQLPanelSaveInfo;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SaveSessionResult;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionsManager;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSaveProcessHandle;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSqlJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupUtil;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainDialog;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainResult;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SessionPersister {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionPersister.class);
    public static final String GROUP_SAVED_SESSION_NAME_DUMMY = "<<<SAVED_SESSION_IN_GROUP_NAME_DUMMY>>>";

    public static boolean saveSession(ISession session) {
        return SessionPersister.saveSession(session, true);
    }

    public static boolean saveSession(ISession session, boolean allowAliasChangeMsg) {
        return SessionPersister.saveSession(session, allowAliasChangeMsg, false);
    }

    public static boolean saveSession(ISession session, boolean allowAliasChangeMsg, boolean gitCommit) {
        return SessionPersister._saveSession(session, allowAliasChangeMsg, gitCommit, null, false).isSessionWasSaved();
    }

    public static SaveSessionResult saveSessionInGroup(ISession sess, SavedSessionsGroupJsonBean group, boolean gitCommit, boolean activeSessionInGroup) {
        return SessionPersister._saveSession(sess, false, gitCommit, group, activeSessionInGroup);
    }

    private static SaveSessionResult _saveSession(ISession session, boolean allowAliasChangeMsg, boolean gitCommit, SavedSessionsGroupJsonBean group, boolean activeSessionInGroup) {
        SavedSessionJsonBean savedSessionJsonBean = session.getSavedSession();
        SQLAlias alias = session.getAlias();
        SavedSessionsManager savedSessionsManager = Main.getApplication().getSavedSessionsManager();
        if (null == group) {
            if (null == savedSessionJsonBean) {
                String savedSessionNameTemplate = SavedSessionUtil.createSavedSessionNameTemplate(session);
                String newName = SavedSessionUtil.showEditSavedSessionNameDialog(GUIUtils.getOwningFrame(session.getSessionPanel()), savedSessionNameTemplate);
                if (null == newName) {
                    return SaveSessionResult.ofUserCanceledSavingSession();
                }
                savedSessionJsonBean = new SavedSessionJsonBean();
                savedSessionJsonBean.setName(newName);
                savedSessionJsonBean.setDefaultAliasIdString(alias.getIdentifier().toString());
                savedSessionJsonBean.setAliasNameForDebug(alias.getName());
            } else if (allowAliasChangeMsg && !alias.getIdentifier().toString().equals(savedSessionJsonBean.getDefaultAliasIdString()) && savedSessionsManager.isShowAliasChangeMsg()) {
                DontShowAgainDialog dlgMsg = new DontShowAgainDialog((Window)GUIUtils.getOwningFrame(session.getSessionPanel()), s_stringMgr.getString("SessionPersister.change.default.alias.to", savedSessionJsonBean.getName(), alias.getName(), alias.getUrl()), s_stringMgr.getString("SessionPersister.change.default.alias.how.to"));
                dlgMsg.setTitle(s_stringMgr.getString("SessionPersister.change.default.alias.title"));
                DontShowAgainResult res = dlgMsg.showAndGetResult("SessionPersister.change.alias", 600, 250);
                savedSessionsManager.setShowAliasChangeMsg(false == res.isDontShowAgain());
                if (res.isCancel()) {
                    return SaveSessionResult.ofUserCanceledSavingSession();
                }
                if (res.isYes()) {
                    savedSessionJsonBean.setDefaultAliasIdString(alias.getIdentifier().toString());
                    savedSessionJsonBean.setAliasNameForDebug(alias.getName());
                }
            }
        } else {
            if (null == savedSessionJsonBean) {
                savedSessionJsonBean = new SavedSessionJsonBean();
                savedSessionJsonBean.setName("<<<SAVED_SESSION_IN_GROUP_NAME_DUMMY>>>_groupId_" + group.getGroupId());
            }
            savedSessionJsonBean.setGroupId(group.getGroupId());
            savedSessionJsonBean.setDefaultAliasIdString(alias.getIdentifier().toString());
            savedSessionJsonBean.setAliasNameForDebug(alias.getName());
        }
        List<SQLPanelSaveInfo> sqlPanelSaveInfoList = SavedSessionUtil.getAllSQLPanelsOrderedAndTyped(session);
        SessionSaveProcessHandle sessionSaveProcessHandle = savedSessionsManager.beginStore(savedSessionJsonBean, true);
        SQLEditorActivator sqlEditorActivator = new SQLEditorActivator();
        for (SQLPanelSaveInfo sqlPanelSaveInfo : sqlPanelSaveInfoList) {
            SessionSqlJsonBean sessionSqlJsonBean = savedSessionsManager.storeFile(savedSessionJsonBean, sqlPanelSaveInfo, gitCommit);
            sqlEditorActivator.prepareToActivateSQLPanelSaveInfo(sqlPanelSaveInfo, sessionSqlJsonBean, SavedSessionsGroupUtil.shouldForceToFocusActiveSqlEditor(group, activeSessionInGroup));
        }
        savedSessionJsonBean.setActiveSessionInGroup(activeSessionInGroup);
        savedSessionsManager.endStore(savedSessionJsonBean, group, sessionSaveProcessHandle);
        Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SessionPersister.saved.session.msg", savedSessionJsonBean.getName()));
        SavedSessionUtil.initSessionWithSavedSession(savedSessionJsonBean, session);
        sqlEditorActivator.activate();
        Main.getApplication().getMainFrame().getMainFrameTitleHandler().updateMainFrameTitle();
        return SaveSessionResult.ofSessionWasSaved(sqlEditorActivator);
    }

    public static void moveSavedSessionFromGroupToStandalone(SavedSessionJsonBean savedSessionToMove, String newSavedSessionName) {
        String groupId = savedSessionToMove.getGroupId();
        savedSessionToMove.setName(newSavedSessionName);
        savedSessionToMove.setGroupId(null);
        SessionSaveProcessHandle sessionSaveProcessHandle = Main.getApplication().getSavedSessionsManager().beginStore(savedSessionToMove, false);
        Main.getApplication().getSavedSessionsManager().endStore(savedSessionToMove, null, sessionSaveProcessHandle);
        Main.getApplication().getSavedSessionsManager().removeGroupIfEmpty(groupId);
    }
}

