/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup;

import java.util.Objects;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SessionListCellPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class GroupDlgSessionWrapper {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GroupDlgSessionWrapper.class);
    private final SavedSessionsGroupJsonBean _groupBeingEdited;
    private final ISession _session;
    private boolean _groupMember;
    private SessionListCellPanel _sessionListCellPanel = new SessionListCellPanel();

    public GroupDlgSessionWrapper(SavedSessionsGroupJsonBean groupBeingEdited, ISession session, boolean groupMember) {
        this._groupBeingEdited = groupBeingEdited;
        this._session = session;
        this._groupMember = groupMember;
    }

    public ISession getSession() {
        return this._session;
    }

    public SessionListCellPanel initAndGetListCellPanelForRendering(boolean isSelected, boolean cellHasFocus) {
        this._sessionListCellPanel.initForRendering(this, isSelected, cellHasFocus);
        return this._sessionListCellPanel;
    }

    public boolean isGroupMember() {
        return this._groupMember;
    }

    public void invertGroupMemberFlag() {
        this._groupMember = !this._groupMember;
    }

    public void setGroupMemberFlag(boolean b) {
        this._groupMember = b;
    }

    public SavedSessionsGroupJsonBean getGroupBeingEdited() {
        return this._groupBeingEdited;
    }

    public boolean isShowSavedSessionOrGroupMemberInfoToolTip(int xInSessionListCellPanel, int yInSessionListCellPanel) {
        return this._sessionListCellPanel.btnSavedSessionOrGroupMemberInfo.getBounds().contains(xInSessionListCellPanel, yInSessionListCellPanel) && false == this.isAllowToMoveGroupMemberToSavedSession(xInSessionListCellPanel, yInSessionListCellPanel);
    }

    public boolean isAllowToMoveGroupMemberToSavedSession(int xInSessionListCellPanel, int yInSessionListCellPanel) {
        return this._sessionListCellPanel.btnSavedSessionOrGroupMemberInfo.getBounds().contains(xInSessionListCellPanel, yInSessionListCellPanel) && this.isSessionMemberOfGroupBeingEdited();
    }

    private boolean isSessionMemberOfGroupBeingEdited() {
        return null != this._session.getSavedSession() && null != this._groupBeingEdited && Objects.equals(this._groupBeingEdited.getGroupId(), this._session.getSavedSession().getGroupId());
    }

    public boolean isInChkSelected(int xInSessionListCellPanel, int yInSessionListCellPanel) {
        return this._sessionListCellPanel.chkSelected.getBounds().contains(xInSessionListCellPanel, yInSessionListCellPanel) || this._sessionListCellPanel.txtSessName.getBounds().contains(xInSessionListCellPanel, yInSessionListCellPanel);
    }

    public String getSavedSessionOrGroupMemberInfoToolTip() {
        if (null == this._session.getSavedSession()) {
            return null;
        }
        if (StringUtilities.isEmpty(this._session.getSavedSession().getGroupId(), true)) {
            return s_stringMgr.getString("GroupDlgSessionWrapper.saved.session.tooltip", this._session.getSavedSession().getName());
        }
        if (null == this._groupBeingEdited || !Objects.equals(this._groupBeingEdited.getGroupId(), this._session.getSavedSession().getGroupId())) {
            SavedSessionsGroupJsonBean group = Main.getApplication().getSavedSessionsManager().getGroup(this._session.getSavedSession().getGroupId());
            return s_stringMgr.getString("GroupDlgSessionWrapper.member.of.other.group.tooltip", group.getGroupName());
        }
        return null;
    }

    public String toString() {
        return this._session.toString();
    }
}

