/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SQLEditorActivator;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionLoader;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.tuple.Pair;

public class MultipleSavedSessionOpener {
    private static final ILogger s_log = LoggerController.createLogger(MultipleSavedSessionOpener.class);

    public static void openSavedSessions(List<SavedSessionJsonBean> savedSessionsToOpen) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> MultipleSavedSessionOpener._openSavedSessions(savedSessionsToOpen));
    }

    private static void _openSavedSessions(final List<SavedSessionJsonBean> savedSessionsToOpen) {
        try {
            final Thread theExecutorServicesThread = Thread.currentThread();
            final AtomicInteger calledbackSessionsCounter = new AtomicInteger();
            final ArrayList sessionFramesToLoad = new ArrayList();
            for (final SavedSessionJsonBean savedSession : savedSessionsToOpen) {
                SQLAlias alias = SavedSessionUtil.getAliasForIdString(savedSession.getDefaultAliasIdString());
                ConnectToAliasCallBack callback = new ConnectToAliasCallBack(alias){

                    @Override
                    public void sessionInternalFrameCreated(SessionInternalFrame sessionInternalFrame) {
                        sessionFramesToLoad.add(Pair.of((Object)sessionInternalFrame, (Object)savedSession));
                        if (savedSessionsToOpen.size() == calledbackSessionsCounter.incrementAndGet()) {
                            MultipleSavedSessionOpener.loadSavedSessionIntoOpenSession(sessionFramesToLoad);
                        }
                        theExecutorServicesThread.interrupt();
                    }

                    @Override
                    public void errorOccurred(Throwable th, boolean connectingHasBeenCanceledByUser) {
                        calledbackSessionsCounter.incrementAndGet();
                        super.errorOccurred(th, connectingHasBeenCanceledByUser);
                        if (savedSessionsToOpen.size() == calledbackSessionsCounter.incrementAndGet()) {
                            MultipleSavedSessionOpener.loadSavedSessionIntoOpenSession(sessionFramesToLoad);
                        }
                        theExecutorServicesThread.interrupt();
                    }
                };
                SwingUtilities.invokeAndWait(() -> new ConnectToAliasCommand(alias, true, callback).executeConnect());
                try {
                    Thread.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    String msg = "MultipleSavedSessionOpener received interrupt to continue opening Sessions after Saved Session " + (null == savedSession.getGroupId() ? savedSession.getName() : savedSession.getAliasNameForDebug()) + " was opened";
                    s_log.info(msg);
                }
            }
        }
        catch (Exception e) {
            s_log.error(e);
        }
    }

    private static void loadSavedSessionIntoOpenSession(List<Pair<SessionInternalFrame, SavedSessionJsonBean>> sessionFramesToLoad) {
        SQLEditorActivator activatorOfActiveSessionInGroup = null;
        for (Pair<SessionInternalFrame, SavedSessionJsonBean> pair : sessionFramesToLoad) {
            SQLEditorActivator buf = SavedSessionLoader.load((SessionInternalFrame)pair.getLeft(), (SavedSessionJsonBean)pair.getRight());
            if (!((SavedSessionJsonBean)pair.getRight()).isActiveSessionInGroup()) continue;
            activatorOfActiveSessionInGroup = buf;
        }
        if (null != activatorOfActiveSessionInGroup) {
            SQLEditorActivator finalActivatorOfActiveSessionInGroup = activatorOfActiveSessionInGroup;
            SwingUtilities.invokeLater(() -> finalActivatorOfActiveSessionInGroup.activate());
        }
        sessionFramesToLoad.clear();
    }
}

