/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionSqlJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.fw.id.UidIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class SavedSessionGrouped {
    private final SavedSessionsGroupJsonBean _group;
    private final List<SavedSessionJsonBean> _savedSessionJsonBeans = new ArrayList<SavedSessionJsonBean>();

    public SavedSessionGrouped(SavedSessionJsonBean savedSessionJsonBean) {
        this(savedSessionJsonBean, null);
    }

    public SavedSessionGrouped(SavedSessionJsonBean savedSessionJsonBean, SavedSessionsGroupJsonBean group) {
        if (!StringUtilities.isEmpty(savedSessionJsonBean.getGroupId(), true) && null == group) {
            throw new IllegalArgumentException("If savedSessionJsonBean has a groupId the group parameter must not be null.");
        }
        this._savedSessionJsonBeans.add(savedSessionJsonBean);
        this._group = group;
    }

    public static SavedSessionGrouped of(SavedSessionJsonBean savedSession) {
        return new SavedSessionGrouped(savedSession);
    }

    public SavedSessionsGroupJsonBean getGroup() {
        return this._group;
    }

    public void addSavedSession(SavedSessionJsonBean savedSessionJsonBean) {
        this._savedSessionJsonBeans.add(savedSessionJsonBean);
    }

    public String getName() {
        if (null != this._group) {
            return this._group.getGroupName();
        }
        return this._savedSessionJsonBeans.get(0).getName();
    }

    public void setName(String name) {
        if (null != this._group) {
            this._group.setGroupName(name);
        } else {
            this._savedSessionJsonBeans.get(0).setName(name);
        }
    }

    public boolean isGroup() {
        return null != this._group;
    }

    public SavedSessionJsonBean getNoGroupedSavedSession() {
        if (!this.isGroup()) {
            return this._savedSessionJsonBeans.get(0);
        }
        throw new IllegalStateException("This is a Saved Session Group");
    }

    public List<SavedSessionJsonBean> getSavedSessions() {
        return this._savedSessionJsonBeans;
    }

    public boolean matchesFilterText(String filterText) {
        if (null != this._group && StringUtils.containsIgnoreCase((CharSequence)this._group.getGroupName(), (CharSequence)filterText)) {
            return true;
        }
        for (SavedSessionJsonBean savedSessionJsonBean : this._savedSessionJsonBeans) {
            if (null == this._group && StringUtils.containsIgnoreCase((CharSequence)savedSessionJsonBean.getName(), (CharSequence)filterText)) {
                return true;
            }
            if (!this.matchesSavedSessionContents(savedSessionJsonBean, filterText)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSavedSessionContents(SavedSessionJsonBean savedSession, String filterText) {
        SQLAlias alias;
        if (!StringUtilities.isEmpty(savedSession.getDefaultAliasIdString(), true) && null != (alias = Main.getApplication().getAliasesAndDriversManager().getAlias(new UidIdentifier(savedSession.getDefaultAliasIdString()))) && (null != alias.getName() && StringUtils.containsIgnoreCase((CharSequence)alias.getName(), (CharSequence)filterText) || null != alias.getUrl() && StringUtils.containsIgnoreCase((CharSequence)alias.getUrl(), (CharSequence)filterText) || null != alias.getUserName() && StringUtils.containsIgnoreCase((CharSequence)alias.getUserName(), (CharSequence)filterText))) {
            return true;
        }
        for (SessionSqlJsonBean sessionSQL : savedSession.getSessionSQLs()) {
            if (StringUtilities.isEmpty(sessionSQL.getExternalFilePath(), true) || !StringUtils.containsIgnoreCase((CharSequence)sessionSQL.getExternalFilePath(), (CharSequence)filterText)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSavedSession(SavedSessionJsonBean savedSession) {
        return this._savedSessionJsonBeans.contains(savedSession);
    }

    public String toString() {
        return this.getName();
    }
}

