/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SaveSessionResult;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionPersister;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.GroupDlgSessionWrapper;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionGrouped;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupDlg;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupDlgDefaultButton;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SessionsListCtrl;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SavedSessionsGroupCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SavedSessionsGroupCtrl.class);
    private static final String PROPS_KEY_DEFAULT_BUTTON = "GroupOfSavedSessionsCtrl.GroupSaveDefaultButton";
    private static final String PROPS_KEY_OPTIMIZE_STORING_OPEN_SESSIONS = "GroupOfSavedSessionsCtrl.OptimizeStoringOpenSessions";
    private final SavedSessionsGroupDlg _dlg = new SavedSessionsGroupDlg();
    private final SessionsListCtrl _sessionsListCtrl;
    private SavedSessionsGroupJsonBean _groupBeingEdited;
    private boolean _inOnGroupMembersChanged;
    private boolean _groupNameEditedByUser;

    public SavedSessionsGroupCtrl() {
        String groupId = null;
        if (null != Main.getApplication().getSessionManager().getActiveSession().getSavedSession()) {
            groupId = Main.getApplication().getSessionManager().getActiveSession().getSavedSession().getGroupId();
        }
        this._groupBeingEdited = Main.getApplication().getSavedSessionsManager().getGroup(groupId);
        if (null != this._groupBeingEdited) {
            this._dlg.lblOfTxtGroupName.setText(s_stringMgr.getString("SavedSessionsGroupDlg.name.of.existing.group"));
            this._dlg.txtGroupName.setText(this._groupBeingEdited.getGroupName());
        } else {
            this._dlg.lblOfTxtGroupName.setText(s_stringMgr.getString("SavedSessionsGroupDlg.name.of.new.group"));
        }
        this._sessionsListCtrl = new SessionsListCtrl(this._dlg.lstSessions, this._groupBeingEdited, () -> this.onGroupMembersChanged());
        this.onGroupMembersChanged();
        this._dlg.txtGroupName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SavedSessionsGroupCtrl.this.handleGroupNameUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SavedSessionsGroupCtrl.this.handleGroupNameUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SavedSessionsGroupCtrl.this.handleGroupNameUpdated();
            }
        });
        this._dlg.lstSessions.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SavedSessionsGroupCtrl.this.onKeyPressed(e);
            }
        });
        this._dlg.chkOptimizeStoringOpenSessions.setSelected(Props.getBoolean(PROPS_KEY_OPTIMIZE_STORING_OPEN_SESSIONS, false));
        this._dlg.chkOptimizeStoringOpenSessions.addActionListener(e -> this.onChkOptimizeStoringOpenSessions());
        this.onChkOptimizeStoringOpenSessions();
        this._dlg.btnSaveGroup.addActionListener(e -> this.onSaveGroup(false));
        this._dlg.btnGitCommitGroup.addActionListener(e -> this.onSaveGroup(true));
        this._dlg.btnDelete.addActionListener(e -> this.onDelete());
        this._dlg.btnCancel.addActionListener(e -> this.close());
        SavedSessionsGroupDlgDefaultButton defaultButton = SavedSessionsGroupDlgDefaultButton.valueOf(Props.getString(PROPS_KEY_DEFAULT_BUTTON, SavedSessionsGroupDlgDefaultButton.SAVE.name()));
        this._dlg.cboDefaultButton.setSelectedItem((Object)defaultButton);
        this._dlg.cboDefaultButton.addActionListener(e -> this.initDefaultButton((SavedSessionsGroupDlgDefaultButton)((Object)((Object)this._dlg.cboDefaultButton.getSelectedItem()))));
        this.initDefaultButton(defaultButton);
        GUIUtils.forceFocus(this._dlg.txtGroupName);
        GUIUtils.initLocation(this._dlg, 600, 500);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onChkOptimizeStoringOpenSessions() {
        if (this._dlg.chkOptimizeStoringOpenSessions.isSelected()) {
            this._sessionsListCtrl.selectAll();
        }
    }

    private void onKeyPressed(KeyEvent e) {
        if (0 == this._dlg.lstSessions.getModel().getSize()) {
            return;
        }
        if (e.getKeyCode() == 75 && 0 != (e.getModifiersEx() & 0x80)) {
            boolean allInGroup = false == this._dlg.lstSessions.getSelectedValuesList().stream().anyMatch(w -> !w.isGroupMember());
            for (GroupDlgSessionWrapper wrapper : this._dlg.lstSessions.getSelectedValuesList()) {
                wrapper.setGroupMemberFlag(!allInGroup);
            }
            this._dlg.lstSessions.repaint();
        }
    }

    private void initDefaultButton(SavedSessionsGroupDlgDefaultButton defaultButton) {
        switch (defaultButton) {
            case SAVE: {
                this._dlg.getRootPane().setDefaultButton(this._dlg.btnSaveGroup);
                break;
            }
            case GIT_COMMIT: {
                this._dlg.getRootPane().setDefaultButton(this._dlg.btnGitCommitGroup);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown default button: " + defaultButton);
            }
        }
    }

    private void handleGroupNameUpdated() {
        if (this._inOnGroupMembersChanged) {
            return;
        }
        this._groupNameEditedByUser = true;
    }

    private void onSaveGroup(boolean gitCommit) {
        List<GroupDlgSessionWrapper> toSaveWrappers = this._sessionsListCtrl.getInCurrentGroupList();
        if (toSaveWrappers.isEmpty()) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("SavedSessionsGroupCtrl.error.cannot.save.empty.group.message.box"));
            return;
        }
        String groupName = this._dlg.txtGroupName.getText();
        if (StringUtilities.isEmpty(groupName, true)) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("SavedSessionsGroupCtrl.error.no.group.name"));
            return;
        }
        for (GroupDlgSessionWrapper sessWrp : toSaveWrappers) {
            if (this._dlg.chkOptimizeStoringOpenSessions.isSelected() || null == sessWrp.getSession().getSavedSession() || null != this._groupBeingEdited && Objects.equals(this._groupBeingEdited.getGroupId(), sessWrp.getSession().getSavedSession().getGroupId())) continue;
            int res = JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("SavedSessionsGroupCtrl.saved.session.exists.message"), s_stringMgr.getString("SavedSessionsGroupCtrl.saved.session.exists.title"), 1);
            if (res == 0) break;
            return;
        }
        this.close();
        SwingUtilities.invokeLater(() -> this.saveSessionGroup(gitCommit, groupName, toSaveWrappers.stream().map(w -> w.getSession()).collect(Collectors.toList())));
    }

    private void onDelete() {
        int res = JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("SavedSessionsGroupCtrl.delete.group.message"), s_stringMgr.getString("SavedSessionsGroupCtrl.delete.group.title"), 1);
        if (res != 0) {
            return;
        }
        if (null != this._groupBeingEdited) {
            SavedSessionGrouped groupBeingEdited = Main.getApplication().getSavedSessionsManager().getSavedSessionGrouped(this._groupBeingEdited.getGroupId());
            Main.getApplication().getSavedSessionsManager().delete(List.of(groupBeingEdited));
        }
        String groupNameForMessagePanel = null != this._groupBeingEdited ? this._groupBeingEdited.getGroupName() : this._dlg.txtGroupName.getText();
        Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SavedSessionsGroupCtrl.group.was.delete", groupNameForMessagePanel));
        this.close();
    }

    private void saveSessionGroup(boolean gitCommit, String groupName, List<ISession> toSave) {
        SavedSessionGrouped groupBeforeSave = null;
        if (null == this._groupBeingEdited) {
            this._groupBeingEdited = new SavedSessionsGroupJsonBean();
        } else {
            groupBeforeSave = Main.getApplication().getSavedSessionsManager().getSavedSessionGrouped(this._groupBeingEdited.getGroupId());
        }
        this._groupBeingEdited.setGroupName(groupName);
        ISession activeSessionInGroup = Main.getApplication().getSessionManager().getActiveSession();
        SaveSessionResult saveSessionResultOfActiveSession = null;
        Collections.reverse(toSave);
        for (ISession sess : toSave) {
            if (null != sess.getSavedSession() && !StringUtilities.isEmpty(sess.getSavedSession().getGroupId(), true)) {
                Main.getApplication().getSavedSessionsManager().removeGroupIfEmpty(sess.getSavedSession().getGroupId());
            }
            SaveSessionResult buf = SessionPersister.saveSessionInGroup(sess, this._groupBeingEdited, gitCommit, sess == activeSessionInGroup);
            if (sess != activeSessionInGroup) continue;
            saveSessionResultOfActiveSession = buf;
        }
        if (null != groupBeforeSave) {
            for (SavedSessionJsonBean savedSessionBefore : groupBeforeSave.getSavedSessions()) {
                if (!toSave.stream().noneMatch(s -> Objects.equals(s.getSavedSession(), savedSessionBefore))) continue;
                Optional<ISession> sessionToDetach = Main.getApplication().getSessionManager().getOpenSessions().stream().filter(s -> Objects.equals(s.getSavedSession(), savedSessionBefore)).findFirst();
                if (sessionToDetach.isPresent()) {
                    SavedSessionUtil.detachInternalFiles(sessionToDetach.get());
                    sessionToDetach.get().setSavedSession(null);
                    if (Objects.equals(activeSessionInGroup, sessionToDetach.get())) {
                        saveSessionResultOfActiveSession = null;
                    }
                }
                savedSessionBefore.setGroupId(null);
                Main.getApplication().getSavedSessionsManager().delete(SavedSessionGrouped.of(savedSessionBefore));
            }
        }
        if (null != saveSessionResultOfActiveSession && saveSessionResultOfActiveSession.isSessionWasSaved()) {
            saveSessionResultOfActiveSession.activatePreviousSqlEditor();
        }
    }

    private void close() {
        Props.putString(PROPS_KEY_DEFAULT_BUTTON, ((SavedSessionsGroupDlgDefaultButton)((Object)this._dlg.cboDefaultButton.getSelectedItem())).name());
        Props.putBoolean(PROPS_KEY_OPTIMIZE_STORING_OPEN_SESSIONS, this._dlg.chkOptimizeStoringOpenSessions.isSelected());
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onGroupMembersChanged() {
        try {
            this._inOnGroupMembersChanged = true;
            if (this._groupNameEditedByUser || null != this._groupBeingEdited) {
                return;
            }
            if (this._sessionsListCtrl.getInCurrentGroupList().isEmpty()) {
                this._dlg.txtGroupName.setText(s_stringMgr.getString("SavedSessionsGroupCtrl.error.cannot.save.empty.group"));
                return;
            }
            this._dlg.txtGroupName.setText(SavedSessionUtil.createSessionGroupNameTemplate(this._sessionsListCtrl.getInCurrentGroupList().stream().map(w -> w.getSession()).collect(Collectors.toList())));
        }
        finally {
            this._inOnGroupMembersChanged = false;
        }
    }
}

