/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SessionPersister;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.GroupDlgSessionWrapper;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.GroupMembersListener;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SavedSessionsGroupJsonBean;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.savedsessionsgroup.SessionListCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.ToolTipDisplay;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class SessionsListCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionsListCtrl.class);
    private final JList<GroupDlgSessionWrapper> _lstSessions;
    private final GroupMembersListener _groupMembersListener;
    private final ToolTipDisplay _toolTipDisplay;

    public SessionsListCtrl(JList<GroupDlgSessionWrapper> lstSessions, SavedSessionsGroupJsonBean groupBeingEdited, GroupMembersListener groupMembersListener) {
        this._groupMembersListener = groupMembersListener;
        this._lstSessions = lstSessions;
        DefaultListModel<GroupDlgSessionWrapper> sessionListModel = new DefaultListModel<GroupDlgSessionWrapper>();
        sessionListModel.addAll(this.createSessionWrapperList(groupBeingEdited));
        this._lstSessions.setCellRenderer(new SessionListCellRenderer());
        this._lstSessions.setModel(sessionListModel);
        this._lstSessions.setSelectionMode(2);
        this._toolTipDisplay = GUIUtils.createToolTipDisplay(this._lstSessions);
        this._lstSessions.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SessionsListCtrl.this.onMousePressed(e);
            }
        });
    }

    private List<GroupDlgSessionWrapper> createSessionWrapperList(SavedSessionsGroupJsonBean groupBeingEdited) {
        ArrayList<GroupDlgSessionWrapper> ret = new ArrayList<GroupDlgSessionWrapper>();
        for (ISession session : Main.getApplication().getSessionManager().getOpenSessions()) {
            GroupDlgSessionWrapper sessWrp = null == groupBeingEdited ? new GroupDlgSessionWrapper(groupBeingEdited, session, null == session.getSavedSession()) : (null != session.getSavedSession() && Objects.equals(groupBeingEdited.getGroupId(), session.getSavedSession().getGroupId()) ? new GroupDlgSessionWrapper(groupBeingEdited, session, true) : new GroupDlgSessionWrapper(groupBeingEdited, session, false));
            ret.add(sessWrp);
        }
        return ret;
    }

    private void onMousePressed(MouseEvent e) {
        int yInSessionListCellPanel;
        this._toolTipDisplay.closeToolTip();
        int index = this._lstSessions.locationToIndex(e.getPoint());
        if (-1 == index) {
            return;
        }
        GroupDlgSessionWrapper wrapper = this._lstSessions.getModel().getElementAt(index);
        Rectangle listCellBounds = this._lstSessions.getCellBounds(index, index);
        if (!listCellBounds.contains(e.getX(), e.getY())) {
            return;
        }
        int xInSessionListCellPanel = e.getX() - listCellBounds.x;
        if (wrapper.isInChkSelected(xInSessionListCellPanel, yInSessionListCellPanel = e.getY() - listCellBounds.y)) {
            if (0 == (e.getModifiersEx() & 0x80) && 0 == (e.getModifiersEx() & 0x40)) {
                wrapper.invertGroupMemberFlag();
                this._lstSessions.repaint();
                this._groupMembersListener.groupMembersChanged();
            }
        } else if (wrapper.isShowSavedSessionOrGroupMemberInfoToolTip(xInSessionListCellPanel, yInSessionListCellPanel)) {
            this._toolTipDisplay.displayToolTip(e.getX(), e.getY(), wrapper.getSavedSessionOrGroupMemberInfoToolTip());
        } else if (wrapper.isAllowToMoveGroupMemberToSavedSession(xInSessionListCellPanel, yInSessionListCellPanel)) {
            this.onMoveGroupMemberToSavedSession(wrapper);
        }
    }

    private void onMoveGroupMemberToSavedSession(GroupDlgSessionWrapper wrapperToMove) {
        String newName;
        SavedSessionJsonBean savedSessionToMove = wrapperToMove.getSession().getSavedSession();
        String savedSessionNameTemplate = savedSessionToMove.getName();
        if (StringUtils.startsWith((CharSequence)savedSessionNameTemplate, (CharSequence)"<<<SAVED_SESSION_IN_GROUP_NAME_DUMMY>>>")) {
            savedSessionNameTemplate = SavedSessionUtil.createSavedSessionNameTemplate(wrapperToMove.getSession());
        }
        if (null == (newName = SavedSessionUtil.showEditSavedSessionNameDialog(GUIUtils.getOwningWindow(this._lstSessions), savedSessionNameTemplate, savedSessionToMove, s_stringMgr.getString("SessionsListCtrl.move.group.member.title")))) {
            return;
        }
        SessionPersister.moveSavedSessionFromGroupToStandalone(savedSessionToMove, newName);
        wrapperToMove.setGroupMemberFlag(false);
        this._lstSessions.repaint();
        Main.getApplication().getMainFrame().getMainFrameTitleHandler().updateMainFrameTitle();
    }

    public List<GroupDlgSessionWrapper> getInCurrentGroupList() {
        ArrayList<GroupDlgSessionWrapper> ret = new ArrayList<GroupDlgSessionWrapper>();
        for (int i = 0; i < this._lstSessions.getModel().getSize(); ++i) {
            GroupDlgSessionWrapper sessWrp = this._lstSessions.getModel().getElementAt(i);
            if (!sessWrp.isGroupMember()) continue;
            ret.add(sessWrp);
        }
        return ret;
    }

    public void selectAll() {
        for (int i = 0; i < this._lstSessions.getModel().getSize(); ++i) {
            this._lstSessions.getModel().getElementAt(i).setGroupMemberFlag(true);
        }
        this._lstSessions.repaint();
        this._groupMembersListener.groupMembersChanged();
    }
}

